/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.datatype.oracle;

import com.oceanbase.tools.datamocker.datatype.AbstractDigitDataType;
import com.oceanbase.tools.datamocker.datatype.DataTypeFactory;
import com.oceanbase.tools.datamocker.generator.BaseDigitalGenerator;
import com.oceanbase.tools.datamocker.model.config.DigitDataTypeConfig;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import java.math.BigDecimal;

public class OracleNumberType
extends AbstractDigitDataType<BigDecimal> {
    private final int scale;
    private final int precision;

    public OracleNumberType(int precision, BaseDigitalGenerator<BigDecimal> generator, BigDecimal defaultValue, Boolean allowNull) {
        super(generator, ObModeType.OB_ORACLE, defaultValue, allowNull);
        this.scale = 0;
        this.precision = precision;
    }

    public OracleNumberType(int precision, int scale, BigDecimal defaultValue, Boolean allowNull) {
        super(ObModeType.OB_ORACLE, defaultValue, allowNull);
        this.scale = scale;
        this.precision = precision;
    }

    public OracleNumberType(int precision, int scale, BaseDigitalGenerator<BigDecimal> generator, BigDecimal defaultValue, Boolean allowNull) {
        super(generator, ObModeType.OB_ORACLE, defaultValue, allowNull);
        this.scale = scale;
        this.precision = precision;
    }

    @Override
    protected BigDecimal maxValueForType() {
        return this.maxOrMinForNumber();
    }

    @Override
    protected BigDecimal minValueForType() {
        return this.maxOrMinForNumber().multiply(new BigDecimal(-1));
    }

    @Override
    protected Long limitForType(BigDecimal lowValue, BigDecimal highValue) {
        BigDecimal interval = highValue.subtract(lowValue);
        BigDecimal result = interval.multiply(new BigDecimal(Double.toString(Math.pow(10.0, this.scale)))).setScale(0, 1);
        if (result.compareTo(new BigDecimal(Long.MAX_VALUE)) > 0) {
            return Long.MAX_VALUE;
        }
        return Long.valueOf(result.toPlainString());
    }

    @Override
    protected BigDecimal preProcessingBeforeOutput(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.setScale(this.scale, 5);
    }

    @Override
    public String convertToSqlString(BigDecimal value) {
        if (value == null) {
            return "NULL";
        }
        return value.setScale(this.scale, 5).toPlainString();
    }

    public String toString() {
        return String.format("NUMBER(%d, %d)", this.precision, this.scale);
    }

    private BigDecimal maxOrMinForNumber() {
        BigDecimal secondPartMaxValue;
        if (this.precision > 38 || this.precision < 0 || this.scale < -84 || this.scale > 127) {
            throw new MockerException("Precision or scale is out of range");
        }
        int interval = this.precision - this.scale;
        int firstPartWidth = Math.max(interval, 0);
        BigDecimal firstPartMaxValue = new BigDecimal(Double.toString(Math.pow(10.0, firstPartWidth))).subtract(BigDecimal.ONE);
        BigDecimal factor = new BigDecimal(Double.toString(Math.pow(10.0, -this.scale - 1)));
        if (this.scale >= 0) {
            if (firstPartWidth > 0) {
                factor = factor.multiply(new BigDecimal(5));
                secondPartMaxValue = BigDecimal.ONE.subtract(new BigDecimal(Double.toString(Math.pow(10.0, -this.scale)))).add(factor);
            } else {
                factor = factor.multiply(new BigDecimal(4));
                secondPartMaxValue = new BigDecimal(Double.toString(Math.pow(10.0, interval))).subtract(new BigDecimal(Double.toString(Math.pow(10.0, -this.scale)))).add(factor);
            }
        } else {
            factor = factor.multiply(new BigDecimal(5));
            firstPartMaxValue = firstPartMaxValue.subtract(factor);
            secondPartMaxValue = BigDecimal.ZERO;
        }
        return firstPartMaxValue.add(secondPartMaxValue);
    }

    @Override
    public DataTypeFactory<OracleNumberType, DigitDataTypeConfig, BaseDigitalGenerator<BigDecimal>> getFactory() {
        return DataTypeFactory.getInstance("OB_ORACLE_NUMBER");
    }
}

