/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.datatype.oracle;

import com.oceanbase.tools.datamocker.datatype.AbstractByteDataType;
import com.oceanbase.tools.datamocker.datatype.DataTypeFactory;
import com.oceanbase.tools.datamocker.generator.BaseByteGenerator;
import com.oceanbase.tools.datamocker.model.config.CharDataTypeConfig;
import com.oceanbase.tools.datamocker.model.enums.ObModeType;

public class OracleRawType
extends AbstractByteDataType {
    private final Integer width;

    public OracleRawType(byte[] defaultValue, Boolean allowNull, Integer width, BaseByteGenerator generator) {
        super(generator, ObModeType.OB_ORACLE, defaultValue, allowNull);
        this.width = width;
    }

    public OracleRawType(byte[] defaultValue, Boolean allowNull, Integer width) {
        super(ObModeType.OB_ORACLE, defaultValue, allowNull);
        this.width = width;
    }

    @Override
    public DataTypeFactory<OracleRawType, CharDataTypeConfig, BaseByteGenerator> getFactory() {
        return DataTypeFactory.getInstance("OB_ORACLE_RAW");
    }

    @Override
    protected Integer maxValueForType() {
        return this.width;
    }

    @Override
    public String convertToSqlString(byte[] value) {
        if (value == null) {
            return "NULL";
        }
        return String.format("utl_raw.cast_to_raw('%s')", new String(value));
    }

    public String toString() {
        return String.format("RAW(%d)", this.width);
    }
}

