/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.generator;

import com.oceanbase.tools.datamocker.generator.BaseGenerator;
import com.oceanbase.tools.datamocker.model.enums.CharCaseOption;
import com.oceanbase.tools.datamocker.model.enums.CharsetType;

public abstract class BaseCharGenerator
extends BaseGenerator<Integer, String> {
    private final CharCaseOption caseOption;
    private boolean isUnicode = false;
    private CharsetType charsetType = CharsetType.UTF_8;

    public BaseCharGenerator(CharCaseOption caseOption) {
        this.caseOption = caseOption;
    }

    protected abstract Boolean doPreCheck(Integer var1, Integer var2, CharsetType var3, CharCaseOption var4, boolean var5);

    @Override
    public Boolean preCheck(Integer minLength, Integer maxLength) {
        return this.doPreCheck(minLength, maxLength, this.charsetType, this.caseOption, this.isUnicode);
    }

    protected abstract String doGenerate(Integer var1, Integer var2, CharsetType var3, CharCaseOption var4, boolean var5);

    @Override
    public String generate(Integer minLength, Integer maxLength) {
        String returnVal = this.doGenerate(minLength, maxLength, this.charsetType, this.caseOption, this.isUnicode);
        if (CharCaseOption.ALL_LOWER_CASE.equals((Object)this.caseOption)) {
            return returnVal.toLowerCase();
        }
        if (CharCaseOption.ALL_UPPER_CASE.equals((Object)this.caseOption)) {
            return returnVal.toUpperCase();
        }
        return returnVal;
    }

    protected abstract Long doCount(Integer var1, Integer var2, CharsetType var3, CharCaseOption var4, boolean var5);

    @Override
    public Long count(Integer minLength, Integer maxLength) {
        return this.doCount(minLength, maxLength, this.charsetType, this.caseOption, this.isUnicode);
    }

    public void setUnicode(boolean isUnicode) {
        this.isUnicode = isUnicode;
    }

    public void setCharsetType(CharsetType charsetType) {
        this.charsetType = charsetType;
    }
}

