/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.generator;

import com.oceanbase.tools.datamocker.generator.BaseGenerator;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public abstract class BaseDateGenerator<T extends Comparable<? super T>>
extends BaseGenerator<T, T> {
    private TimeUnit minTimeUnit = TimeUnit.SECONDS;
    private int scale;

    protected abstract Boolean doPreCheck(T var1, T var2, int var3, TimeUnit var4);

    @Override
    public Boolean preCheck(T startTime, T endTime) {
        return this.doPreCheck(startTime, endTime, this.scale, this.minTimeUnit);
    }

    protected abstract T doGenerate(T var1, T var2, int var3, TimeUnit var4);

    @Override
    public T generate(T startTime, T endTime) {
        return this.doGenerate(startTime, endTime, this.scale, this.minTimeUnit);
    }

    protected abstract Long doCount(T var1, T var2, int var3, TimeUnit var4);

    @Override
    public Long count(T startTime, T endTime) {
        return this.doCount(startTime, endTime, this.scale, this.minTimeUnit);
    }

    protected int getNanoSeconds(int scale) {
        return new Random().nextInt(new Double(Math.pow(10.0, scale)).intValue());
    }

    public void setMinTimeUnit(TimeUnit minTimeUnit) {
        this.minTimeUnit = minTimeUnit;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }
}

