/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.generator;

import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;

public abstract class BaseGenerator<T extends Comparable<? super T>, V> {
    private V defaultValue;
    private Boolean allowNull = Boolean.FALSE;

    public abstract Boolean preCheck(T var1, T var2);

    protected abstract V generate(T var1, T var2);

    public V next(T leftLimit, T rightLimit) {
        V returnVal;
        int loopCount = 0;
        while ((returnVal = this.generate(leftLimit, rightLimit)) == null) {
            if (this.allowNull.booleanValue()) {
                return null;
            }
            if (this.defaultValue != null) {
                return this.defaultValue;
            }
            if (loopCount++ < 100) continue;
            throw new MockerException(MockerError.OPERATION_FAILURE, "Data generator get too much null data");
        }
        return returnVal;
    }

    public abstract Long count(T var1, T var2);

    public void setDefaultValue(V defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setAllowNull(Boolean allowNull) {
        this.allowNull = allowNull;
    }
}

