/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.generator.chartype;

import com.oceanbase.tools.datamocker.generator.BaseCharGenerator;
import com.oceanbase.tools.datamocker.model.enums.CharCaseOption;
import com.oceanbase.tools.datamocker.model.enums.CharsetType;

public class BoolCharGenerator
extends BaseCharGenerator {
    private final Boolean fixBool;

    public BoolCharGenerator(CharCaseOption caseType, String fixBool) {
        super(caseType);
        this.fixBool = fixBool == null || fixBool.length() == 0 ? null : Boolean.valueOf(fixBool);
    }

    @Override
    protected Boolean doPreCheck(Integer minLength, Integer maxLength, CharsetType charsetType, CharCaseOption caseOption, boolean isUnicode) {
        int realLength = "FALSE".length();
        if (realLength >= minLength) {
            return realLength <= maxLength;
        }
        return false;
    }

    @Override
    protected String doGenerate(Integer minLength, Integer maxLength, CharsetType charsetType, CharCaseOption caseOption, boolean isUnicode) {
        if (this.fixBool != null) {
            return caseOption.convert(this.fixBool.toString());
        }
        if (Math.random() > 0.5) {
            return "TRUE";
        }
        return "FALSE";
    }

    @Override
    protected Long doCount(Integer minLength, Integer maxLength, CharsetType charsetType, CharCaseOption caseOption, boolean isUnicode) {
        if (this.fixBool == null) {
            return 2L;
        }
        return 1L;
    }
}

