/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.generator.chartype;

import com.oceanbase.tools.datamocker.generator.BaseCharGenerator;
import com.oceanbase.tools.datamocker.model.enums.CharCaseOption;
import com.oceanbase.tools.datamocker.model.enums.CharsetType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;

public class RandomNumGenerator
extends BaseCharGenerator {
    private Long start;
    private Long end;

    public RandomNumGenerator(CharCaseOption caseOption, Long start, Long end) {
        super(caseOption);
        if (start == null || end == null) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Start or end for random number generator can not be null");
        }
        if (start.compareTo(end) >= 0) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Start for random number generator can not be bigger than end");
        }
        this.start = start;
        this.end = end;
    }

    @Override
    protected Boolean doPreCheck(Integer minLength, Integer maxLength, CharsetType charsetType, CharCaseOption caseOption, boolean isUnicode) {
        int min = this.start.toString().length();
        int max = this.end.toString().length();
        if (min > maxLength) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Start number is illegal");
        }
        if (max < minLength) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "End number is illegal");
        }
        if (min < minLength) {
            this.start = new Double(Math.pow(10.0, minLength - 1)).longValue();
        }
        if (max > maxLength) {
            this.end = new Double(Math.pow(10.0, maxLength.intValue()) - 1.0).longValue();
        }
        return true;
    }

    @Override
    protected String doGenerate(Integer minLength, Integer maxLength, CharsetType charsetType, CharCaseOption caseOption, boolean isUnicode) {
        long interval = this.end - this.start;
        long result = new Double(Math.random() * (double)interval + (double)this.start.longValue()).longValue();
        if (Long.toString(result).length() < minLength || Long.toString(result).length() > maxLength) {
            throw new MockerException("Number result for random number generator is illegal");
        }
        return Long.toString(result);
    }

    @Override
    protected Long doCount(Integer minLength, Integer maxLength, CharsetType charsetType, CharCaseOption caseOption, boolean isUnicode) {
        int min = this.start.toString().length();
        int max = this.end.toString().length();
        if (min < minLength) {
            this.start = new Double(Math.pow(10.0, minLength - 1)).longValue();
        }
        if (max > maxLength) {
            this.end = new Double(Math.pow(10.0, maxLength.intValue()) - 1.0).longValue();
        }
        return this.end - this.start;
    }
}

