/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.generator.chartype;

import com.oceanbase.tools.datamocker.generator.BaseCharGenerator;
import com.oceanbase.tools.datamocker.model.enums.CharCaseOption;
import com.oceanbase.tools.datamocker.model.enums.CharsetType;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;

public class StepNumGenerator
extends BaseCharGenerator {
    private Long start;
    private Long end;
    private final Long step;
    private final Boolean cycle;
    private Long current = null;

    public StepNumGenerator(CharCaseOption caseOption, Long start, Long end, Long step, Boolean cycle) {
        super(caseOption);
        if (start == null || end == null || step == null || cycle == null) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Start or end or step or cycle for step number generator can not be null");
        }
        if (start.compareTo(end) >= 0) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Start for step number generator can not be bigger than end");
        }
        this.start = start;
        this.end = end;
        this.step = step;
        this.cycle = cycle;
    }

    @Override
    protected Boolean doPreCheck(Integer minLength, Integer maxLength, CharsetType charsetType, CharCaseOption caseOption, boolean isUnicode) {
        int min = this.start.toString().length();
        int max = this.end.toString().length();
        if (min > maxLength) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Start number is illegal");
        }
        if (max < minLength) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "End number is illegal");
        }
        if (min < minLength) {
            this.start = new Double(Math.pow(10.0, minLength - 1)).longValue();
        }
        if (max > maxLength) {
            this.end = new Double(Math.pow(10.0, maxLength.intValue()) - 1.0).longValue();
        }
        return true;
    }

    @Override
    protected String doGenerate(Integer minLength, Integer maxLength, CharsetType charsetType, CharCaseOption caseOption, boolean isUnicode) {
        if (this.step < 0L) {
            return Long.toString(this.minus());
        }
        return Long.toString(this.positive());
    }

    @Override
    protected Long doCount(Integer minLength, Integer maxLength, CharsetType charsetType, CharCaseOption caseOption, boolean isUnicode) {
        int min = this.start.toString().length();
        int max = this.end.toString().length();
        if (min < minLength) {
            this.start = new Double(Math.pow(10.0, minLength - 1)).longValue();
        }
        if (max > maxLength) {
            this.end = new Double(Math.pow(10.0, maxLength.intValue()) - 1.0).longValue();
        }
        return this.end - this.start;
    }

    private long minus() {
        if (this.current == null) {
            this.current = this.end;
            return this.current;
        }
        this.current = this.current + this.step;
        if (this.current < this.start) {
            if (this.cycle.booleanValue()) {
                this.current = this.end;
            } else {
                throw new MockerException(MockerError.OPERATION_FAILURE, "Can not generate more unique date");
            }
        }
        return this.current;
    }

    private long positive() {
        if (this.current == null) {
            this.current = this.start;
            return this.current;
        }
        this.current = this.current + this.step;
        if (this.current > this.end) {
            if (this.cycle.booleanValue()) {
                this.current = this.start;
            } else {
                throw new MockerException(MockerError.OPERATION_FAILURE, "Can not generate more unique date");
            }
        }
        return this.current;
    }
}

