/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.generator.date;

import com.oceanbase.tools.datamocker.generator.BaseDateGenerator;
import java.sql.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.Validate;

public class FixDateGenerator
extends BaseDateGenerator<Date> {
    private final long timestamp;

    public FixDateGenerator(long timestamp) {
        Validate.isTrue((timestamp > 0L ? 1 : 0) != 0, (String)"Timestamp can not be negative for FixDateGenerator");
        this.timestamp = timestamp;
    }

    @Override
    protected Boolean doPreCheck(Date startTime, Date endTime, int scale, TimeUnit minTimeUnit) {
        return this.timestamp >= startTime.getTime() && this.timestamp <= endTime.getTime();
    }

    @Override
    protected Date doGenerate(Date startTime, Date endTime, int scale, TimeUnit minTimeUnit) {
        return new Date(this.timestamp);
    }

    @Override
    protected Long doCount(Date startTime, Date endTime, int scale, TimeUnit minTimeUnit) {
        return 1L;
    }
}

