/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.generator.date;

import com.oceanbase.tools.datamocker.generator.BaseDateGenerator;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;

public class RandomTimestampGenerator
extends BaseDateGenerator<Timestamp> {
    @Override
    protected Boolean doPreCheck(Timestamp startTime, Timestamp endTime, int scale, TimeUnit minTimeUnit) {
        return true;
    }

    @Override
    protected Timestamp doGenerate(Timestamp startTime, Timestamp endTime, int scale, TimeUnit minTimeUnit) {
        long timestamp = (long)(Math.random() * (double)(endTime.getTime() - startTime.getTime()) + (double)startTime.getTime());
        Timestamp returnTimestamp = new Timestamp(timestamp);
        if (!startTime.equals(endTime)) {
            returnTimestamp.setNanos(this.getNanoSeconds(scale));
        }
        return returnTimestamp;
    }

    @Override
    protected Long doCount(Timestamp startTime, Timestamp endTime, int scale, TimeUnit minTimeUnit) {
        long interval = endTime.getTime() - startTime.getTime();
        return minTimeUnit.convert(interval, TimeUnit.MILLISECONDS);
    }
}

