/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.generator.digit;

import com.oceanbase.tools.datamocker.generator.BaseDigitalGenerator;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import java.math.BigDecimal;

public class PoissonGenerator
extends BaseDigitalGenerator<BigDecimal> {
    private final double lambda;

    public PoissonGenerator(double lambda) {
        this.lambda = lambda;
    }

    @Override
    public Boolean preCheck(BigDecimal minValue, BigDecimal maxValue) {
        BigDecimal lambdaValue = new BigDecimal(Double.toString(this.lambda));
        if (lambdaValue.compareTo(minValue) < 0) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Lambda is smaller than min value");
        }
        if (lambdaValue.compareTo(maxValue) >= 0) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Lambda is bigger than max value");
        }
        if (minValue.compareTo(BigDecimal.ZERO) != 0) {
            throw new MockerException(MockerError.PARAMETER_ERROR, "Min value is not equal to zero");
        }
        return true;
    }

    @Override
    public BigDecimal generate(BigDecimal minValue, BigDecimal maxValue) {
        BigDecimal i = minValue;
        BigDecimal a = new BigDecimal(Double.toString(Math.exp(-this.lambda)));
        BigDecimal b = new BigDecimal(Double.toString(1.0));
        do {
            b = b.multiply(new BigDecimal(Double.toString(Math.random())));
            i = i.add(BigDecimal.ONE);
        } while (b.compareTo(a) >= 0 && i.compareTo(maxValue) <= 0);
        return i.subtract(BigDecimal.ONE);
    }

    @Override
    public Long count(BigDecimal minValue, BigDecimal maxValue) {
        return null;
    }
}

