/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.generator.digit;

import com.oceanbase.tools.datamocker.generator.BaseDigitalGenerator;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import java.math.BigDecimal;

public class StepGenerator
extends BaseDigitalGenerator<BigDecimal> {
    private final double step;
    private BigDecimal currentDigit = null;
    private final boolean round;

    public StepGenerator(double step, boolean round) {
        if (step == 0.0) {
            throw new MockerException("Step can not be zero");
        }
        this.step = step;
        this.round = round;
    }

    public StepGenerator(double step) {
        if (step == 0.0) {
            throw new MockerException("Step can not be zero");
        }
        this.step = step;
        this.round = false;
    }

    @Override
    public BigDecimal generate(BigDecimal minValue, BigDecimal maxValue) {
        if (this.step < 0.0) {
            return this.minusStep(minValue, maxValue);
        }
        return this.positive(minValue, maxValue);
    }

    private BigDecimal minusStep(BigDecimal minValue, BigDecimal maxValue) {
        if (this.currentDigit == null) {
            this.currentDigit = maxValue;
            return this.currentDigit;
        }
        this.currentDigit = this.currentDigit.add(new BigDecimal(Double.toString(this.step)));
        if (this.currentDigit.compareTo(minValue) < 0) {
            if (this.round) {
                this.currentDigit = maxValue;
            } else {
                throw new MockerException("Can not generate more unique number");
            }
        }
        return this.currentDigit;
    }

    private BigDecimal positive(BigDecimal minValue, BigDecimal maxValue) {
        if (this.currentDigit == null) {
            this.currentDigit = minValue;
            return this.currentDigit;
        }
        this.currentDigit = this.currentDigit.add(new BigDecimal(Double.toString(this.step)));
        if (this.currentDigit.compareTo(maxValue) > 0) {
            if (this.round) {
                this.currentDigit = minValue;
            } else {
                throw new MockerException("Can not generate more unique number");
            }
        }
        return this.currentDigit;
    }

    @Override
    public Long count(BigDecimal minValue, BigDecimal maxValue) {
        BigDecimal interval = maxValue.subtract(minValue);
        String longValue = interval.divide(new BigDecimal(Double.toString(this.step)).abs(), 1).setScale(0, 1).toPlainString();
        if (new BigDecimal(longValue).compareTo(new BigDecimal(Long.MAX_VALUE)) > 0) {
            return Long.MAX_VALUE;
        }
        return Long.valueOf(longValue);
    }

    @Override
    public Boolean preCheck(BigDecimal minValue, BigDecimal maxValue) {
        return true;
    }
}

