/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.generator.digit;

import com.oceanbase.tools.datamocker.generator.BaseDigitalGenerator;
import java.math.BigDecimal;
import java.util.concurrent.locks.ReentrantLock;

public class UniformGenerator
extends BaseDigitalGenerator<BigDecimal> {
    private volatile BigDecimal factor = null;
    private final ReentrantLock factorWriteLock = new ReentrantLock();

    @Override
    public BigDecimal generate(BigDecimal min, BigDecimal max) {
        BigDecimal currentFactor = this.getFactor(min, max);
        return new BigDecimal(Double.toString(Math.random())).multiply(currentFactor).add(min);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getFactor(BigDecimal minValue, BigDecimal maxValue) {
        if (this.factor == null) {
            this.factorWriteLock.lock();
            try {
                if (this.factor == null) {
                    this.factor = maxValue.subtract(minValue);
                }
                BigDecimal bigDecimal = this.factor;
                return bigDecimal;
            }
            finally {
                this.factorWriteLock.unlock();
            }
        }
        return this.factor;
    }

    @Override
    public Long count(BigDecimal minValue, BigDecimal maxValue) {
        return null;
    }

    @Override
    public Boolean preCheck(BigDecimal minValue, BigDecimal maxValue) {
        return true;
    }
}

