/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.model.config;

import com.oceanbase.tools.datamocker.datatype.AbstractDataType;
import com.oceanbase.tools.datamocker.datatype.DataTypeFactory;
import com.oceanbase.tools.datamocker.model.config.DataTypeConfig;

public class MockColumnConfig {
    private String columnName;
    private DataTypeConfig typeConfig;
    private Boolean allowNull = true;
    private Object defaultValue;
    private AbstractDataType<?, ? extends Comparable<?>> dataType = null;

    public synchronized AbstractDataType<?, ? extends Comparable<?>> getDataType() {
        if (this.dataType != null) {
            return this.dataType;
        }
        DataTypeFactory dataTypeFactory = DataTypeFactory.getInstance(this.typeConfig.getColumnType());
        this.typeConfig.setAllowNull(this.getAllowNull());
        this.typeConfig.setDefaultValue(this.getDefaultValue());
        this.dataType = dataTypeFactory.make(this.typeConfig);
        return this.dataType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public DataTypeConfig getTypeConfig() {
        return this.typeConfig;
    }

    public Boolean getAllowNull() {
        return this.allowNull;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setTypeConfig(DataTypeConfig typeConfig) {
        this.typeConfig = typeConfig;
    }

    public void setAllowNull(Boolean allowNull) {
        this.allowNull = allowNull;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setDataType(AbstractDataType<?, ? extends Comparable<?>> dataType) {
        this.dataType = dataType;
    }
}

