/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.model.config;

import com.oceanbase.tools.datamocker.model.config.MockColumnConfig;
import com.oceanbase.tools.datamocker.model.enums.DuplicateStrategy;
import java.util.List;

public class MockTableConfig {
    private Long totalCount;
    private DuplicateStrategy strategy;
    private Long batchSize;
    private Boolean whetherTruncate;
    private String tableName;
    private String schemaName;
    private Long maxFileOutputSizeInBytes = 0x19000000L;
    private Long maxSingleFileSizeInBytes = 0x3200000L;
    private Long timeoutMillis = 3600000L;
    private String outputDir;
    private int maxErrors = 0;
    private Integer concurrent;
    private List<MockColumnConfig> columns;

    public Long getTotalCount() {
        if (this.totalCount == null) {
            throw new IllegalArgumentException("Max count can not be null");
        }
        if (this.totalCount < 0L) {
            throw new IllegalArgumentException("Max count can not be smaller than 0");
        }
        return this.totalCount;
    }

    public Long getMaxBatchSize() {
        if (this.batchSize == null) {
            throw new IllegalArgumentException("Batch size can not be null");
        }
        if (this.batchSize < 0L) {
            throw new IllegalArgumentException("Batch size can not be smaller than 0");
        }
        if (this.batchSize > 100000L) {
            throw new IllegalArgumentException("Batch size can not be bigger than 100000");
        }
        return this.batchSize;
    }

    public Integer getConcurrent() {
        if (this.concurrent == null || this.concurrent <= 0) {
            return 1;
        }
        long epoch = (long)this.concurrent.intValue() * this.batchSize;
        if (epoch < 0L || epoch >= this.totalCount) {
            int res = Long.valueOf(this.totalCount / this.batchSize).intValue();
            return res <= 0 ? 1 : res;
        }
        return this.concurrent;
    }

    public DuplicateStrategy getStrategy() {
        return this.strategy;
    }

    public Long getBatchSize() {
        return this.batchSize;
    }

    public Boolean getWhetherTruncate() {
        return this.whetherTruncate;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Long getMaxFileOutputSizeInBytes() {
        return this.maxFileOutputSizeInBytes;
    }

    public Long getMaxSingleFileSizeInBytes() {
        return this.maxSingleFileSizeInBytes;
    }

    public Long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    public List<MockColumnConfig> getColumns() {
        return this.columns;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public void setStrategy(DuplicateStrategy strategy) {
        this.strategy = strategy;
    }

    public void setBatchSize(Long batchSize) {
        this.batchSize = batchSize;
    }

    public void setWhetherTruncate(Boolean whetherTruncate) {
        this.whetherTruncate = whetherTruncate;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setMaxFileOutputSizeInBytes(Long maxFileOutputSizeInBytes) {
        this.maxFileOutputSizeInBytes = maxFileOutputSizeInBytes;
    }

    public void setMaxSingleFileSizeInBytes(Long maxSingleFileSizeInBytes) {
        this.maxSingleFileSizeInBytes = maxSingleFileSizeInBytes;
    }

    public void setTimeoutMillis(Long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    public void setConcurrent(Integer concurrent) {
        this.concurrent = concurrent;
    }

    public void setColumns(List<MockColumnConfig> columns) {
        this.columns = columns;
    }
}

