/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.model.mock;

import com.oceanbase.tools.datamocker.datatype.AbstractDataType;
import com.oceanbase.tools.datamocker.util.Pair;
import lombok.NonNull;
import org.apache.commons.lang.Validate;

public class MockColumnData<T> {
    private final String columnName;
    private final Pair<AbstractDataType<T, ? extends Comparable<?>>, T> column;

    public MockColumnData(String columnName, @NonNull AbstractDataType<T, ? extends Comparable<?>> dataType, T columnValue) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked @NonNull but is null");
        }
        Validate.notEmpty((String)columnName, (String)"ColumnName can not be blank");
        this.columnName = columnName;
        this.column = new Pair(dataType, columnValue);
    }

    public T getColumnValue() {
        return this.column.getValue();
    }

    public Object getJdbcColumnValue() {
        return this.column.getKey().convertFromJavaObjectToJdbcObject(this.getColumnValue());
    }

    public String getColumnValueString() {
        return this.column.getKey().convertToSqlString(this.getColumnValue());
    }

    public AbstractDataType<T, ? extends Comparable<?>> getColumnDataType() {
        return this.column.getKey();
    }

    public T toDigest() {
        AbstractDataType<T, Comparable<?>> dataType = this.getColumnDataType();
        return dataType.toDigest(dataType.convertFromJdbcObjectToJavaObject(this.getColumnValue()));
    }

    public String toDigestString() {
        return this.getColumnDataType().convertToSqlString(this.toDigest());
    }

    public String getColumnName() {
        return this.columnName;
    }
}

