/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.model.mock;

import com.oceanbase.tools.datamocker.model.mock.MockColumnData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.lang.Validate;

public class MockRowData {
    private final Map<String, MockColumnData<?>> rowWithMultiColumn;

    public MockRowData(@NonNull List<MockColumnData<?>> columnList) {
        if (columnList == null) {
            throw new NullPointerException("columnList is marked @NonNull but is null");
        }
        this.rowWithMultiColumn = new HashMap(columnList.size());
        for (MockColumnData<?> columnItem : columnList) {
            this.rowWithMultiColumn.put(columnItem.getColumnName(), columnItem);
        }
    }

    public MockRowData() {
        this.rowWithMultiColumn = new HashMap();
    }

    public MockRowData(int rowWidth) {
        Validate.isTrue((rowWidth > 0 ? 1 : 0) != 0, (String)"Row width can not be negative for MockRowData");
        this.rowWithMultiColumn = new HashMap(rowWidth);
    }

    public MockColumnData<?> getMockColumn(@NonNull String columnName) {
        if (columnName == null) {
            throw new NullPointerException("columnName is marked @NonNull but is null");
        }
        return this.rowWithMultiColumn.get(columnName);
    }

    public MockColumnData<?> remove(@NonNull MockColumnData<?> mockColumn) {
        if (mockColumn == null) {
            throw new NullPointerException("mockColumn is marked @NonNull but is null");
        }
        return this.rowWithMultiColumn.remove(mockColumn.getColumnName());
    }

    public MockColumnData<?> remove(@NonNull String columnName) {
        if (columnName == null) {
            throw new NullPointerException("columnName is marked @NonNull but is null");
        }
        return this.rowWithMultiColumn.remove(columnName);
    }

    public MockColumnData<?> addMockColumn(@NonNull MockColumnData<?> mockColumn) {
        if (mockColumn == null) {
            throw new NullPointerException("mockColumn is marked @NonNull but is null");
        }
        return this.rowWithMultiColumn.putIfAbsent(mockColumn.getColumnName(), mockColumn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int columnNum() {
        Map<String, MockColumnData<?>> map = this.rowWithMultiColumn;
        synchronized (map) {
            return this.rowWithMultiColumn.size();
        }
    }

    public Set<String> columnNames() {
        return this.rowWithMultiColumn.keySet();
    }

    public List<MockColumnData<?>> getMockColumns() {
        return new ArrayList(this.rowWithMultiColumn.values());
    }
}

