/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.schedule;

import com.oceanbase.tools.datamocker.core.Dispatcher;
import com.oceanbase.tools.datamocker.core.task.AbstractCallBack;
import com.oceanbase.tools.datamocker.core.task.TableTask;
import com.oceanbase.tools.datamocker.core.task.TableTaskContext;
import com.oceanbase.tools.datamocker.core.task.TableTaskInfo;
import com.oceanbase.tools.datamocker.model.enums.MockTaskStatus;
import com.oceanbase.tools.datamocker.model.exception.MockerError;
import com.oceanbase.tools.datamocker.model.exception.MockerException;
import com.oceanbase.tools.datamocker.schedule.MockContext;
import com.oceanbase.tools.datamocker.schedule.MockExecutorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractScheduler {
    private static final Logger log = LoggerFactory.getLogger(AbstractScheduler.class);
    private final long startTimestamp;
    private final MockExecutorService executorService;

    public AbstractScheduler() {
        ThreadPoolExecutor executor = this.pool();
        Validate.isTrue((executor.getCorePoolSize() == executor.getMaximumPoolSize() ? 1 : 0) != 0, (String)"core pool size has to be equal to max pool size");
        Validate.isTrue((executor.getCorePoolSize() >= 5 ? 1 : 0) != 0, (String)"core pool size of thread pool can not be smaller than 5");
        this.startTimestamp = System.currentTimeMillis();
        this.executorService = new MockExecutorService(executor);
    }

    public MockContext execute(Dispatcher<TableTaskInfo> dispatcher) {
        log.info("Thread pool's initialization has been done. coreSize={},maxSize={}", (Object)this.executorService.getCorePoolSize(), (Object)this.executorService.getMaximumPoolSize());
        MockContext context = new MockContext(this.executorService, dispatcher);
        final AbstractScheduler thisScheduler = this;
        int width = dispatcher.getWidth();
        final boolean[] flags = new boolean[width];
        for (int i = 0; i < width; ++i) {
            flags[i] = true;
        }
        Callable<Integer> scheduleTask = () -> {
            MDC.put((String)"mocktask.workspace", (String)context.getLogDir());
            int totalCount = 0;
            int total = 0;
            long maxTimeout = 0L;
            Long timeoutSum = 0L;
            for (int i = 0; i < dispatcher.getWidth(); ++i) {
                for (int j = 0; j < dispatcher.getTaskSize(i); ++j) {
                    TableTaskInfo tableTask = (TableTaskInfo)dispatcher.getObj(i, j);
                    Long timeout = tableTask.getMetaData().getTimeoutMillis();
                    timeoutSum = timeoutSum + timeout;
                    if (maxTimeout >= timeout) continue;
                    maxTimeout = timeout;
                }
            }
            long failCount = 0L;
            long maxFailCount = maxTimeout / 5000L + 36L;
            while (!Thread.currentThread().isInterrupted() && this.interval() < timeoutSum) {
                for (int i = 0; i < width; ++i) {
                    if (!flags[i]) continue;
                    TableTaskInfo tableTaskInfo = (TableTaskInfo)dispatcher.getObj(i, 0);
                    if (tableTaskInfo == null) {
                        ++total;
                        flags[i] = false;
                        continue;
                    }
                    Set<Set<String>> columnGroups = this.scheduleColumnTask(tableTaskInfo.columnGroups(), this.executorService.getActiveCount(), this.executorService.getCorePoolSize(), this.executorService.getMaximumPoolSize());
                    if (columnGroups == null) {
                        Thread.sleep(5000L);
                        log.warn("Insufficient thread resources, will retry, schema={}, tableName={}", tableTaskInfo.getMetaData().getTableSchema(), (Object)tableTaskInfo.getMetaData().getTableName());
                        if (failCount++ <= maxFailCount) continue;
                        log.warn("Task scheduling operation timeout, will exit, timeout={} min", (Object)(maxTimeout / 60000L + 3L));
                        return totalCount;
                    }
                    this.validateSet(columnGroups);
                    failCount = 0L;
                    if (!this.validateThreadResource(columnGroups, this.executorService.getActiveCount(), this.executorService.getMaximumPoolSize())) {
                        int required = columnGroups.size();
                        log.warn("The thread resource requirements given by the custom scheduling algorithm exceed the currently available thread resources, requiredThreadCount={}, availableThreadCount={}", (Object)required, (Object)(this.executorService.getMaximumPoolSize() - this.executorService.getActiveCount()));
                        return totalCount;
                    }
                    dispatcher.pop(i);
                    flags[i] = false;
                    TableTask tableTask = new TableTask(tableTaskInfo, columnGroups, i);
                    tableTask.getContext().setStatus(MockTaskStatus.PENDING);
                    tableTask.init(this.executorService, new AbstractCallBack<TableTaskContext>(){

                        @Override
                        public void doOnSuccess(TableTaskContext param) {
                            flags[param.getTopIndex()] = true;
                            try {
                                thisScheduler.onSuccess(param);
                            }
                            catch (Exception e) {
                                log.warn("Failed to call onSuccess", (Throwable)e);
                            }
                        }

                        @Override
                        public void doOnFailure(TableTaskContext param, Throwable e) {
                            flags[param.getTopIndex()] = true;
                            try {
                                thisScheduler.onFailure(param, e);
                            }
                            catch (Exception e1) {
                                log.warn("Failed to call onFailure", e);
                            }
                        }
                    });
                    if (this.executorService.isShutdown()) {
                        log.warn("Task has been shutdown, total task executed is {}", (Object)totalCount);
                        return totalCount;
                    }
                    ++totalCount;
                    TableTaskContext tableTaskContext = this.executorService.submit(tableTask);
                    context.appendContext(tableTaskContext);
                }
                if (total < width) continue;
            }
            log.info("Scheduled task has been completed, totalTask={}, duration={}", (Object)totalCount, (Object)DurationFormatUtils.formatDurationHMS((long)this.interval()));
            MDC.clear();
            return totalCount;
        };
        this.executorService.submitCallable(scheduleTask);
        return context;
    }

    private boolean validateThreadResource(Set<Set<String>> columnGroups, int active, int max) {
        int freeResource = max - active;
        if (freeResource < 0) {
            throw new IllegalStateException("Free resource thread pool size is smaller than zero");
        }
        return columnGroups.size() < freeResource;
    }

    private void validateSet(Set<Set<String>> input) {
        ArrayList<Set<String>> middle = new ArrayList<Set<String>>(input);
        for (int i = 0; i < middle.size(); ++i) {
            HashSet copyObj = new HashSet((Collection)middle.get(i));
            for (int j = i + 1; j < middle.size(); ++j) {
                copyObj.retainAll((Collection)middle.get(j));
                if (copyObj.size() == 0) continue;
                throw new MockerException(MockerError.PARAMETER_ERROR, "Column group set is illegal");
            }
        }
    }

    private long interval() {
        return System.currentTimeMillis() - this.startTimestamp;
    }

    protected ThreadPoolExecutor pool() {
        int corePoolSize = Math.max(Runtime.getRuntime().availableProcessors(), 5);
        return new ThreadPoolExecutor(corePoolSize, corePoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("ob-data-mocker-thread-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    protected abstract Set<Set<String>> scheduleColumnTask(Set<String> var1, int var2, int var3, int var4);

    protected abstract void onSuccess(TableTaskContext var1);

    protected abstract void onFailure(TableTaskContext var1, Throwable var2);
}

