/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.schedule;

import com.oceanbase.tools.datamocker.core.Dispatcher;
import com.oceanbase.tools.datamocker.core.task.TableTaskContext;
import com.oceanbase.tools.datamocker.schedule.MockExecutorService;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import lombok.NonNull;

public class MockContext {
    private final Integer totalTableTaskCount;
    private final String logDir;
    private final List<TableTaskContext> tables;
    private final MockExecutorService service;

    public MockContext(@NonNull MockExecutorService service, @NonNull Dispatcher<?> dispatcher) {
        if (service == null) {
            throw new NullPointerException("service is marked @NonNull but is null");
        }
        if (dispatcher == null) {
            throw new NullPointerException("dispatcher is marked @NonNull but is null");
        }
        this.logDir = dispatcher.getLogDir();
        this.tables = new LinkedList<TableTaskContext>();
        this.service = service;
        this.totalTableTaskCount = dispatcher.getTotalCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendContext(TableTaskContext context) {
        if (context == null) {
            return;
        }
        List<TableTaskContext> list = this.tables;
        synchronized (list) {
            this.tables.add(context);
        }
    }

    public Boolean shutdown() {
        this.service.shutdown();
        boolean returnVal = true;
        for (TableTaskContext context : this.tables) {
            returnVal &= context.shutdown();
        }
        return returnVal;
    }

    public double getProgress() {
        if (this.tables.size() != 0) {
            double returnVal = 0.0;
            for (TableTaskContext context : this.tables) {
                returnVal += context.getProgress();
            }
            BigDecimal decaimal = new BigDecimal(returnVal * 100.0 / (double)this.totalTableTaskCount.intValue());
            return decaimal.setScale(2, 4).doubleValue();
        }
        return 0.0;
    }

    public String getLogDir() {
        return this.logDir;
    }

    public List<TableTaskContext> getTables() {
        return this.tables;
    }
}

