/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.schedule;

import com.oceanbase.tools.datamocker.core.task.TableTask;
import com.oceanbase.tools.datamocker.core.task.TableTaskContext;
import com.oceanbase.tools.datamocker.model.enums.MockTaskStatus;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.NonNull;

public class MockExecutorService {
    private final ThreadPoolExecutor executor;

    public MockExecutorService(@NonNull ThreadPoolExecutor executor) {
        if (executor == null) {
            throw new NullPointerException("executor is marked @NonNull but is null");
        }
        this.executor = executor;
    }

    private <V> RunnableFuture<V> newTaskFor(Callable<V> task) {
        return new FutureTask<V>(task);
    }

    public synchronized TableTaskContext submit(@NonNull TableTask tableTask) {
        if (tableTask == null) {
            throw new NullPointerException("tableTask is marked @NonNull but is null");
        }
        tableTask.getContext().setStatus(MockTaskStatus.RUNNING);
        this.submitCallable(tableTask.getBeforeTask(), tableTask.getContext());
        return tableTask.getContext();
    }

    public synchronized <V> void submitCallable(@NonNull Callable<V> task, @NonNull TableTaskContext context) {
        if (task == null) {
            throw new NullPointerException("task is marked @NonNull but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked @NonNull but is null");
        }
        if (!context.isShutdown() && !this.isShutdown()) {
            Future<?> future = this.executor.submit(this.newTaskFor(task));
            context.appendHandle(future);
        }
    }

    public synchronized <V> void submitCallable(@NonNull Callable<V> task) {
        if (task == null) {
            throw new NullPointerException("task is marked @NonNull but is null");
        }
        this.executor.submit(this.newTaskFor(task));
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    public int getActiveCount() {
        return this.executor.getActiveCount();
    }

    public int getCorePoolSize() {
        return this.executor.getCorePoolSize();
    }

    public int getMaximumPoolSize() {
        return this.executor.getMaximumPoolSize();
    }
}

