/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.util;

import com.oceanbase.tools.datamocker.util.BitMap;
import java.util.HashSet;
import java.util.Set;

public class DuplicatedJudger {
    private Set<Object> set;
    private BitMap bitMap;
    private int cursor;
    private final int maxCount;

    public DuplicatedJudger(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Count <= 0");
        }
        if (count < 10000) {
            this.set = new HashSet<Object>();
        } else {
            this.bitMap = new BitMap(count);
        }
        this.cursor = 0;
        this.maxCount = count;
    }

    public boolean contains(Object obj) {
        if (this.set != null) {
            return this.set.contains(obj);
        }
        return this.bitMap.contains(obj);
    }

    public boolean add(Object obj) {
        if (++this.cursor > this.maxCount) {
            throw new IllegalStateException(String.format("The max count is %d, can not add more", this.maxCount));
        }
        if (this.set != null) {
            return this.set.add(obj);
        }
        return this.bitMap.add(obj);
    }

    public void clear() {
        this.cursor = 0;
        if (this.set != null) {
            this.set.clear();
        } else {
            this.bitMap.clear();
        }
    }
}

