/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.datamocker.util;

import com.oceanbase.tools.datamocker.util.Column;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SerializeUtil {
    public static <T> List<T> getList(ResultSet result, Class<T> clazz) throws SQLException, InstantiationException, IllegalAccessException {
        if (result == null) {
            return Collections.emptyList();
        }
        ResultSetMetaData metaData = result.getMetaData();
        ArrayList resultList = new ArrayList();
        ArrayList<String> columnList = new ArrayList<String>();
        int columnWidth = metaData.getColumnCount();
        while (result.next()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < columnWidth; ++i) {
                list.add(result.getObject(i + 1));
                if (columnList.size() != i) continue;
                columnList.add(metaData.getColumnLabel(i + 1));
            }
            resultList.add(list);
        }
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        if (resultList.size() == 0) {
            return Collections.emptyList();
        }
        if (((List)resultList.get(0)).size() != columnList.size()) {
            throw new IllegalStateException(String.format("Result set's length \"%d\" is not equal to the length of the column names \"%d\"", ((List)resultList.get(0)).size(), columnList.size()));
        }
        int columnLength = columnList.size();
        for (int i = 0; i < columnLength; ++i) {
            columnMap.putIfAbsent((String)columnList.get(i), i);
        }
        ArrayList<T> returnVal = new ArrayList<T>();
        for (List list : resultList) {
            returnVal.add(SerializeUtil.parseObject(list, columnMap, clazz));
        }
        return returnVal;
    }

    public static <T> T getObject(ResultSet result, Class<T> clazz) throws SQLException, InstantiationException, IllegalAccessException {
        if (result == null) {
            return null;
        }
        ResultSetMetaData metaData = result.getMetaData();
        ArrayList<Object> resultList = new ArrayList<Object>();
        ArrayList<String> columnList = new ArrayList<String>();
        int columnWidth = metaData.getColumnCount();
        if (result.next()) {
            for (int i = 0; i < columnWidth; ++i) {
                resultList.add(result.getObject(i + 1));
                columnList.add(metaData.getColumnLabel(i + 1));
            }
        }
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        if (resultList.size() == 0) {
            return null;
        }
        if (resultList.size() != columnList.size()) {
            throw new IllegalStateException(String.format("Result set's length \"%d\" is not equal to the length of the column names \"%d\"", resultList.size(), columnList.size()));
        }
        int columnLength = columnList.size();
        for (int i = 0; i < columnLength; ++i) {
            columnMap.putIfAbsent((String)columnList.get(i), i);
        }
        return SerializeUtil.parseObject(resultList, columnMap, clazz);
    }

    private static <T> T parseObject(List<Object> input, Map<String, Integer> columnMap, Class<T> clazz) throws IllegalAccessException, InstantiationException {
        Field[] fields;
        T instance = clazz.newInstance();
        for (Field field : fields = clazz.getDeclaredFields()) {
            Integer index;
            Column annotation = field.getDeclaredAnnotation(Column.class);
            String serializationName = null;
            boolean ignore = false;
            if (annotation == null) {
                serializationName = field.getName();
            } else {
                serializationName = annotation.value();
                ignore = annotation.ignore();
            }
            if (ignore || (index = columnMap.get(serializationName)) == null) continue;
            Object value = input.get(index);
            field.setAccessible(true);
            field.set(instance, value);
        }
        return instance;
    }
}

