/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.client;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.base.State;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.model.AdvancedOption;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.Database;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.Manifest;
import com.oceanbase.tools.loaddump.context.TaskContext;
import com.oceanbase.tools.loaddump.dumper.record.RecordFileDumper;
import com.oceanbase.tools.loaddump.dumper.schema.SchemaFileDumper;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.SerializeUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.Objects;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpClient {
    private static final Logger log = LoggerFactory.getLogger(DumpClient.class);
    protected State state;
    protected final DumpParameter parameter;

    protected DumpClient(DumpParameter parameter) {
        this.parameter = parameter;
        ThreadContext.put((String)"task.workspace", (String)parameter.getLogsPath());
    }

    protected DumpClient init() throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(this.parameter.getRootPath()), (Object)"The root path is null");
        if (!(this.parameter.isSkipCheckDir() || FileUtils.isDirEmpty(this.parameter.getRootPath()) || this.parameter.isRetry())) {
            throw new IllegalStateException("The target directory: \"" + this.parameter.getRootPath() + "\" is not empty.");
        }
        ConnectionKey connectionKey = this.parameter.buildConnectionKey();
        if (this.parameter.isSnapshot() && connectionKey.getServerMode().isPreviousV4() && connectionKey.hasNoSysPrivileges()) {
            throw new IllegalArgumentException("Option --snapshot required sys privilege when the OceanBase < 4.0.0.0");
        }
        if (this.parameter.getDataFormat() == DataFormat.CSV) {
            Manifest manifest = new Manifest(this.parameter);
            if (this.parameter.isRetry()) {
                Preconditions.checkState((boolean)manifest.exists(), (String)"Manifest: \"%s\" is missing. You should remove the data directory and retry it again.", (Object)manifest.toPath());
                Manifest origin = (Manifest)SerializeUtils.deserializeObjectByKryo(manifest.toPath());
                Preconditions.checkState((boolean)Objects.deepEquals(origin, manifest), (String)"Manifest: \"%s\" has been modified. You should clean dir and retry it again.", (Object)manifest.toPath());
            }
            SerializeUtils.serializeObjectByKryo(manifest, manifest.toPath());
            log.info("Manifest: \"{}\" has been saved", (Object)manifest.toPath());
        }
        AdvancedOption advancedOption = new AdvancedOption(this.parameter, connectionKey.getServerMode());
        Database database = connectionKey.getMetadataProvider().queryDatabase(connectionKey, advancedOption);
        this.parameter.setDatabase(database);
        this.parameter.setDatabaseName(database.getSchemaName());
        if (this.parameter.isIncludeDdl()) {
            this.parameter.getWhiteListMap().putAll(advancedOption.getAllowedObjectMap());
        }
        this.state = State.INITIAL;
        return this;
    }

    public TaskContext dumpSchema() throws Exception {
        Preconditions.checkState((this.state == State.INITIAL ? 1 : 0) != 0, (Object)"Not initialized");
        Preconditions.checkArgument((boolean)this.parameter.isIncludeDdl(), (Object)"Option [--ddl] is missing");
        return new SchemaFileDumper(this.parameter).prepare().dumpSchemaAsync();
    }

    public TaskContext dumpRecord() throws Exception {
        Preconditions.checkState((this.state == State.INITIAL ? 1 : 0) != 0, (Object)"Not initialized");
        Preconditions.checkArgument((this.parameter.getDataFormat() != null ? 1 : 0) != 0, (String)"Option %s is missing", (Object)DataFormat.appendRecordOption());
        return new RecordFileDumper(this.parameter).prepare().dumpRecordAsync();
    }

    public static class Builder {
        private final DumpParameter parameter;

        public Builder(DumpParameter parameter) {
            this.parameter = parameter;
        }

        public DumpClient build() throws Exception {
            return new DumpClient(this.parameter).init();
        }
    }
}

