/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.client;

import com.alibaba.druid.pool.DruidPooledStatement;
import com.google.common.base.Preconditions;
import com.oceanbase.jdbc.OceanBaseStatement;
import com.oceanbase.tools.loaddump.base.State;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.model.AdvancedOption;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.Summary;
import com.oceanbase.tools.loaddump.common.model.TaskDetail;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.concurrent.ExecutorTemplate;
import com.oceanbase.tools.loaddump.manager.session.SessionManager;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteLoadClient {
    private static final Logger log = LoggerFactory.getLogger(RemoteLoadClient.class);
    protected State state;
    protected final LoadParameter parameter;
    protected List<String> tables;
    private static final String LOAD_DATA_SQL = "LOAD DATA {0} INFILE {1} INTO TABLE {2} FIELDS TERMINATED BY {3} OPTIONALLY ENCLOSED BY {4} LINES TERMINATED BY {5}";

    private RemoteLoadClient(LoadParameter parameter) {
        this.parameter = parameter;
        ThreadContext.put((String)"task.workspace", (String)parameter.getLogsPath());
    }

    public RemoteLoadClient init() throws Exception {
        this.state = State.INITIAL;
        Preconditions.checkArgument((this.parameter.getStorageConfig() == null ? 1 : 0) != 0, (Object)"Remote load only supports local file system.");
        Preconditions.checkArgument((this.parameter.getDataFormat() == DataFormat.CSV ? 1 : 0) != 0, (Object)"Remote load only supports CSV format");
        ConnectionKey connectionKey = this.parameter.buildConnectionKey();
        AdvancedOption advancedOption = new AdvancedOption(this.parameter, connectionKey.getServerMode());
        this.tables = connectionKey.getMetadataProvider().queryTableNames(connectionKey, advancedOption);
        return this;
    }

    public int loadRecord() {
        List<TaskDetail> taskDetails = this.loadInternal();
        log.info(new Summary("All Remote Load Tasks Finished", taskDetails).toHumanReadableFormat());
        return taskDetails.stream().allMatch(TaskDetail::isSuccess) ? 0 : 1;
    }

    private List<TaskDetail> loadInternal() {
        boolean isFile;
        ConnectionKey connectionKey = this.parameter.getConnectionKey();
        SessionManager sessionManager = connectionKey.getSessionManager();
        String path = this.parameter.getFilePath();
        boolean bl = isFile = path.endsWith(".csv") || path.endsWith(".txt") || path.endsWith(".dat");
        if (isFile && this.tables.size() != 1) {
            throw new IllegalArgumentException("File name does not match the table count");
        }
        int parallel = this.parameter.getParallel();
        String parallelHint = parallel > 0 ? "/*+parallel(" + this.parameter.getParallel() + ")*/" : "";
        ExecutorTemplate<TaskDetail> template = new ExecutorTemplate<TaskDetail>("remote-load-", this.parameter.getThreads());
        for (String table : this.tables) {
            String realFilePath = isFile ? path : FileUtils.toPath(path, table + ".csv");
            String sql = MessageFormat.format(LOAD_DATA_SQL, parallelHint, StringUtils.wrapWithQuot(realFilePath), table, StringUtils.wrapWithQuot(this.parameter.getColumnSeparator()), StringUtils.wrapWithQuot(this.parameter.getColumnDelimiter()), StringUtils.wrapWithQuot(StringEscapeUtils.escapeJava((String)this.parameter.getLineSeparator())));
            template.submit(() -> {
                TaskDetail taskDetail = new TaskDetail();
                taskDetail.setSchema(connectionKey.getDatabase());
                taskDetail.setObject(table);
                taskDetail.setType(ObjectType.TABLE.getName());
                try (Connection conn = sessionManager.getPooledBizConnection();){
                    DruidPooledStatement druidStmt = (DruidPooledStatement)conn.createStatement();
                    OceanBaseStatement obStmt = (OceanBaseStatement)druidStmt.getStatement();
                    log.info("Execute SQL: {}", (Object)sql);
                    long affected = obStmt.executeLargeUpdate(sql);
                    taskDetail.setCount(affected);
                    taskDetail.setState(TaskState.SUCCESS);
                }
                catch (Exception e) {
                    if (e.toString().contains("File not exist")) {
                        log.warn("No files are available for table {}, which might be empty at the time of backup.", (Object)table);
                        taskDetail.setCount(0L);
                        taskDetail.setState(TaskState.SUCCESS);
                        return taskDetail;
                    }
                    taskDetail.setState(TaskState.FAILURE);
                    taskDetail.setError(ExceptionUtils.getRootCauseMessage(e));
                    log.error("Dump [{}] failed!", (Object)table, (Object)e);
                }
                return taskDetail;
            });
        }
        return template.waitForResult();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private LoadParameter parameter;

        public Builder parameter(LoadParameter parameter) {
            this.parameter = parameter;
            return this;
        }

        public RemoteLoadClient build() throws Exception {
            return new RemoteLoadClient(this.parameter).init();
        }
    }
}

