/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.cmd;

import com.alibaba.druid.filter.config.ConfigTools;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.cmd.Common;
import com.oceanbase.tools.loaddump.cmd.Connection;
import com.oceanbase.tools.loaddump.cmd.ObjectTypes;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.enums.StorageType;
import com.oceanbase.tools.loaddump.common.model.BaseParameter;
import com.oceanbase.tools.loaddump.common.model.MapObject;
import com.oceanbase.tools.loaddump.common.model.RuntimeMetrics;
import com.oceanbase.tools.loaddump.common.model.StorageUri;
import com.oceanbase.tools.loaddump.common.model.storage.BaseStorageConfig;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.OssStorageConfig;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.S3StorageConfig;
import com.oceanbase.tools.loaddump.common.model.storage.remote.hdfs.HdfsStorageConfig;
import com.oceanbase.tools.loaddump.context.TaskContext;
import com.oceanbase.tools.loaddump.decrypt.DecryptTools;
import com.oceanbase.tools.loaddump.decrypt.SecureContent;
import com.oceanbase.tools.loaddump.function.context.ControlContext;
import com.oceanbase.tools.loaddump.function.context.ControlDescription;
import com.oceanbase.tools.loaddump.function.visitor.DefaultControlParserVisitor;
import com.oceanbase.tools.loaddump.manager.ControlManager;
import com.oceanbase.tools.loaddump.manager.session.SessionProperties;
import com.oceanbase.tools.loaddump.utils.CodecUtils;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.JacksonUtils;
import com.oceanbase.tools.loaddump.utils.LogUtils;
import com.oceanbase.tools.loaddump.utils.ProgressLogger;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import com.oceanbase.tools.loaddump.utils.TimeUtils;
import com.oceanbase.tools.loaddump.vmoption.JvmArgs;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public abstract class AbstractCommandParser {
    private static final Logger log = LoggerFactory.getLogger(AbstractCommandParser.class);
    public static final List<String> STARS_WILDCARD = Lists.newArrayList((Object[])new String[]{"*", "\\*"});
    private static final Set<String> SECURITY_SENSITIVE_ARGS = Sets.newHashSet((Object[])new String[]{"--password", "--sys-password"});
    @CommandLine.ArgGroup(validate=false, heading="%nCommon options:%n")
    protected Common common;
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;

    protected abstract BaseParameter parseCommandArgs() throws Exception;

    protected void parseCommonArgs(BaseParameter parameter) throws Exception {
        List columnNames;
        Common.Base base = this.common.getBase();
        this.assertParamConflict(base);
        String filePath = base.getFilePath();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(filePath), (Object)"Option -f/--file-path is missing.");
        parameter.setFilePath(filePath);
        this.parseDataConfig(base, parameter);
        SecureContent secureContent = DecryptTools.decrypt();
        this.parseJdbcConfig(base, parameter, secureContent);
        if (StringUtils.isNotBlank(base.getStorageUri())) {
            this.parseStorageConfig(base.getStorageUri(), parameter, secureContent);
        }
        parameter.setRetry(base.isRetry());
        parameter.setLogPath(base.getLogPath());
        parameter.setCtlPath(base.getCtlPath());
        parameter.setThreads(Math.min(Math.max(1, base.getThread()), Constants.MAXIMUM_IO_THREADS));
        parameter.setParallel(base.getParallel());
        if (base.getExcludeDataTypes() != null) {
            List dataTypes = base.getExcludeDataTypes().stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(dataTypes), (Object)"Cli args of --exclude-data-types is required");
            parameter.getExcludeDataTypes().addAll(dataTypes);
        }
        if (base.getExcludeColumnNames() != null) {
            columnNames = base.getExcludeColumnNames().stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(columnNames), (Object)"Cli args of --exclude-column-names is required");
            parameter.getExcludeColumnNames().addAll(columnNames);
        }
        if (base.getIncludeColumnNames() != null) {
            columnNames = base.getIncludeColumnNames().stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(columnNames), (Object)"Cli args of --include-column-names is required");
            parameter.getIncludeColumnNames().addAll(columnNames);
        }
    }

    protected Map<String, String> buildTableMapping() {
        ObjectTypes objectTypes = this.common.getObjectTypes();
        Preconditions.checkArgument((objectTypes != null && CollectionUtils.isNotEmpty(objectTypes.getTables()) ? 1 : 0) != 0, (Object)"--table is missing");
        List<String> sourceTables = JvmArgs.getSourceTables();
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(sourceTables), (Object)"Please check vm args -DsourceTable is missing");
        List targetTables = objectTypes.getTables().stream().map(t -> DBUtils.extractObjectName(t, null)).collect(Collectors.toList());
        Preconditions.checkArgument((targetTables.size() == sourceTables.size() ? 1 : 0) != 0, (Object)"Args of --table and -DsourceTable is not match");
        return Stream.iterate(0, t -> t + 1).limit(sourceTables.size()).collect(Collectors.toMap(sourceTables::get, targetTables::get));
    }

    protected void printParseArgs() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("Parsed args:\n");
        List options = this.spec.options();
        for (CommandLine.Model.OptionSpec opt : options) {
            try {
                if (opt.getter() == null || opt.getValue() == null || opt.initialValue() != null && (opt.initialValue() == null || opt.getValue().equals(opt.initialValue()))) continue;
                String arg = opt.longestName();
                sb.append("[").append(arg).append("] ");
                if (SECURITY_SENSITIVE_ARGS.contains(arg)) {
                    sb.append("******\n");
                    continue;
                }
                if ("--storage-uri".equals(arg)) {
                    sb.append(StorageUri.maskSensitiveParams(opt.getValue().toString())).append("\n");
                    continue;
                }
                sb.append(opt.getValue().toString()).append("\n");
            }
            catch (Exception exception) {}
        }
        LogUtils.info(sb.toString());
    }

    protected void doFinally(RuntimeMetrics metrics, int status) {
        if (JvmArgs.isBackupRestoreMode && metrics != null) {
            metrics.setStatusCode(status == 0 ? 3 : 4);
            metrics.setProgress(100.0);
            ProgressLogger.info(JacksonUtils.toJsonString(metrics), new Object[0]);
        }
        if (!JvmArgs.isDebugable) {
            if (status == 0) {
                if (JvmArgs.isMultiTask) {
                    log.info("System exit {}", (Object)status);
                } else {
                    LogUtils.info("System exit {}", status);
                }
            } else if (JvmArgs.isMultiTask) {
                log.error("System exit {}", (Object)status);
            } else {
                LogUtils.error("System exit {}", status);
            }
            System.exit(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long waitUntilDone(@NonNull TaskContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        long status = 0L;
        long count = 1L;
        while (!context.isAllTasksFinished()) {
            this.logProgress(context, count);
            ++count;
            TimeUtils.sleep(TimeUnit.MILLISECONDS, 1000L);
        }
        try {
            context.shutdown();
            log.info("Shutdown task context finished");
        }
        catch (Exception e) {
            try {
                context.shutdownNow();
                log.info("Shutdown task context immediately finished");
            }
            catch (Exception ex) {
                log.error("Shutdown task context immediately failed", (Throwable)ex);
            }
        }
        finally {
            if (!context.isAllTasksSuccessed()) {
                context.getFailureTaskDetails().forEach(t -> log.error("Error: {}", (Object)t.getError()));
                status = 1L;
            }
            log.info(context.getProgress().toString());
            log.info(context.getSummary().toHumanReadableFormat());
        }
        return status;
    }

    protected void logProgress(TaskContext context, long counter) {
        if (counter % 5L == 0L) {
            log.info(context.getProgress().toString());
            RuntimeMetrics metrics = context.getRuntimeMetrics();
            metrics.setStatusCode(2);
            ProgressLogger.info(JacksonUtils.toJsonString(metrics), new Object[0]);
        }
        if (counter % 30L == 0L) {
            log.info(context.getServerStatus().toString());
        }
    }

    protected String parseSpecialChar(String character) throws Exception {
        String trimmedChar = character.trim().toLowerCase();
        if (trimmedChar.startsWith("0x") && trimmedChar.length() % 4 == 0) {
            return CodecUtils.decodeHex(trimmedChar.split("0x"));
        }
        if (trimmedChar.startsWith("x") && trimmedChar.length() % 3 == 0) {
            return CodecUtils.decodeHex(trimmedChar.split("x"));
        }
        return character;
    }

    protected Map<ObjectType, Set<String>> parseAllowedObjects(ObjectTypes objects) {
        HashMap<ObjectType, Set<String>> allowedObjectMap = new HashMap<ObjectType, Set<String>>(16);
        this.parseObjectNames(allowedObjectMap, ObjectType.TABLE, objects.getTables(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.TABLE_GROUP, objects.getTableGroups(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.VIEW, objects.getViews(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.TRIGGER, objects.getTriggers(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.SEQUENCE, objects.getSequences(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.SYNONYM, objects.getSynonyms(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.PUBLIC_SYNONYM, objects.getPublicSynonyms(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.FUNCTION, objects.getFunctions(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.PROCEDURE, objects.getProcedures(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.TYPE, objects.getTypes(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.TYPE_BODY, objects.getTypeBodies(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.PACKAGE, objects.getPackages(), objects.isAll());
        this.parseObjectNames(allowedObjectMap, ObjectType.PACKAGE_BODY, objects.getPackageBodies(), objects.isAll());
        Preconditions.checkArgument((boolean)MapUtils.isNotEmpty(allowedObjectMap), (Object)"Cli args of --table,--view or other options are required");
        return allowedObjectMap;
    }

    protected Map<ObjectType, Set<String>> parseDisallowedObjects(ObjectTypes objects) {
        HashMap<ObjectType, Set<String>> disallowedObjectMap = new HashMap<ObjectType, Set<String>>(16);
        this.parseObjectNames(disallowedObjectMap, ObjectType.TABLE, objects.getExcludeTables(), false);
        return disallowedObjectMap;
    }

    protected void parseObjectNames(Map<ObjectType, Set<String>> objectMap, ObjectType objectType, List<String> objectNames, boolean withAll) {
        List<Object> list = objectNames = objectNames == null ? Lists.newArrayList() : objectNames;
        if (withAll || objectNames.size() == 1 && STARS_WILDCARD.contains(objectNames.get(0))) {
            if (!withAll) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)objectNames.get(0)), (String)"Invalid object names: \"%s\"", (Object)objectNames.get(0));
            }
            objectMap.computeIfAbsent(objectType, v -> new HashSet()).addAll(Sets.newHashSet());
        } else {
            Set specifiedObjects = objectNames.stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(specifiedObjects)) {
                objectMap.computeIfAbsent(objectType, v -> new HashSet()).addAll(specifiedObjects);
            }
        }
    }

    protected void parseControlFiles(BaseParameter parameter, Set<String> tableSet) throws Exception {
        Collection controlFiles;
        File ctlPath = new File(parameter.getCtlPath());
        if (ctlPath.isFile()) {
            controlFiles = Lists.newArrayList((Object[])new File[]{ctlPath});
            Preconditions.checkState((tableSet.size() == 1 ? 1 : 0) != 0, (Object)"A control file must correspond to one table. Please check the --table, --ctl-path options");
        } else {
            controlFiles = FileUtils.listFiles((File)ctlPath, (String[])new String[]{"ctrl"}, (boolean)true);
            if (CollectionUtils.isEmpty((Collection)controlFiles)) {
                LogUtils.info("No control files were defined in the path: \"{}\"", parameter.getCtlPath());
                return;
            }
        }
        ServerMode serverMode = parameter.buildConnectionKey().getServerMode();
        String schemaName = DBUtils.extractObjectName(parameter.getDatabaseName(), serverMode);
        List<String> tableNames = DBUtils.toCaseSensitiveNames(serverMode, tableSet);
        ArrayList<String> withinCtrls = new ArrayList<String>(tableSet.size());
        for (File controlFile : controlFiles) {
            String table;
            String controlFilePath = controlFile.getAbsolutePath();
            String controlFileName = DBUtils.extractObjectName(controlFile.getName(), null);
            if (ctlPath.isFile()) {
                table = tableNames.get(0);
            } else {
                table = FileUtils.getFileNameWithoutSuffix(controlFileName);
                String tableIgnoreCase = DBUtils.extractObjectName(table, serverMode);
                if (CollectionUtils.isNotEmpty(tableNames) && !tableNames.contains(tableIgnoreCase)) {
                    LogUtils.info("The control file: \"{}\" is unexpected, ignore it", controlFilePath);
                    continue;
                }
            }
            ControlContext controlContext = DefaultControlParserVisitor.doParse(controlFile, serverMode);
            controlContext.setSchemaName(schemaName);
            controlContext.setTableName(table);
            List<String> columnNameList = controlContext.getColumnNameList();
            if (CollectionUtils.isEmpty(columnNameList)) {
                LogUtils.info("The control file: \"{}\" is invalid, ignore it", controlFilePath);
                continue;
            }
            LinkedHashMap<String, MapObject> singleTableMapping = new LinkedHashMap<String, MapObject>();
            for (String columnName : columnNameList) {
                ControlDescription description = controlContext.getControlDescriptionByColumnName(columnName);
                MapObject mapObj = new MapObject();
                if (description.getMappedIndex() != null) {
                    mapObj.setSource(description.getMappedIndex() - 1);
                }
                mapObj.setGeneratedDefine(description.getGeneratedDefine());
                singleTableMapping.put(columnName, mapObj);
            }
            parameter.getColumnNameMapping().put(table, singleTableMapping);
            ControlManager controlManager = ControlManager.newInstance();
            controlManager.register(schemaName, table, controlContext);
            parameter.setControlManager(controlManager);
            withinCtrls.add(controlContext.getTableName());
            LogUtils.info("Parse ctrl definition: \"{}\" success", controlFilePath);
        }
        withinCtrls.forEach(tableNames::remove);
        tableNames.forEach(t -> LogUtils.info("No valid control file was defined for the table: \"{}\"", t));
    }

    private void parseDataConfig(Common.Base base, BaseParameter parameter) throws Exception {
        if (base.isSql()) {
            parameter.setDataFormat(DataFormat.SQL);
        } else if (base.isCsv()) {
            parameter.setDataFormat(DataFormat.CSV);
            parameter.setColumnSeparator(base.getColumnSeparator());
            parameter.setColumnDelimiter(base.getColumnDelimiter());
        } else if (base.isCut()) {
            parameter.setNullString(null);
            parameter.setDataFormat(DataFormat.CUT);
            Preconditions.checkArgument((!StringUtils.isEmpty(base.getColumnSplitter()) ? 1 : 0) != 0, (Object)"--column-splitter is missing");
            parameter.setColumnSplitter(this.parseSpecialChar(base.getColumnSplitter()));
        } else if (base.isOrc()) {
            parameter.setDataFormat(DataFormat.ORC);
        } else if (base.isPar()) {
            parameter.setDataFormat(DataFormat.PAR);
        }
        parameter.setIncludeDdl(base.isDdl());
        parameter.setFileEncoding(base.getFileEncoding());
        parameter.setNlsDateFormat(base.getNlsDateFormat());
        parameter.setNlsTimestampFormat(base.getNlsTimestampFormat());
        parameter.setNlsTimestampTzFormat(base.getNlsTimestampTzFormat());
        parameter.setSkipHeader(base.isSkipHeader());
        parameter.setNullString(base.getNullString());
        parameter.setEmptyString(base.getEmptyString());
        parameter.setTrailingDelimiter(base.isTrailDelimiter());
        parameter.setLineSeparator(this.parseSpecialChar(base.getLineSeparator()));
        parameter.setWithTrim(base.isWithTrim());
        Character escapeChar = base.getEscapeCharacter();
        parameter.setEscapeCharacter(Character.isWhitespace(escapeChar.charValue()) ? null : escapeChar);
    }

    private void parseJdbcConfig(Common.Base base, BaseParameter parameter, SecureContent secureContent) throws Exception {
        Connection conn = this.common.getConnection();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(conn.getHost()), (Object)"Option -h/--host is required");
        Preconditions.checkArgument((conn.getPort() > 0 && conn.getPort() <= 65535 ? 1 : 0) != 0, (Object)"Option -P/--port is either missing or invalid");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(conn.getUser()), (Object)"Option -u/--user is required");
        parameter.setHost(conn.getHost());
        parameter.setPort(conn.getPort());
        parameter.setSocksProxyHost(SessionProperties.getString("jdbc.url.socks.proxy.host"));
        parameter.setSocksProxyPort(SessionProperties.getString("jdbc.url.socks.proxy.port"));
        parameter.setUser(DBUtils.convertObjectName(conn.getUser(), null));
        parameter.setTenant(conn.getTenant());
        parameter.setCluster(conn.getCluster());
        if (StringUtils.isBlank(conn.getPassword())) {
            parameter.setPassword(secureContent.getPassword());
        } else {
            parameter.setPassword(conn.getPassword());
        }
        String databaseName = conn.getDatabase();
        databaseName = StringUtils.isBlank(databaseName) ? conn.getUser() : databaseName;
        parameter.setDatabaseName(databaseName);
        parameter.setConnectDatabaseName(DBUtils.convertObjectName(databaseName, null));
        parameter.setSysUser(conn.getSysUser());
        if (StringUtils.isBlank(conn.getSysPassword())) {
            String secureFile = System.getProperty("obproxy.configurationFile");
            if (StringUtils.isBlank(secureFile) || !FileUtils.exists(secureFile)) {
                parameter.setSysPassword(secureContent.getSysPassword());
            } else {
                AbstractCommandParser.decryptBySecureFile(secureFile, parameter);
            }
        } else {
            parameter.setSysPassword(conn.getSysPassword());
        }
        String charset = base.getCharacterSet();
        if (StringUtils.isNotBlank(charset)) {
            SessionProperties.setString("jdbc.url.character.encoding", charset);
        }
        parameter.setLogicalDatabase(base.isLogicalDatabase());
        parameter.setNoSys(parameter.isLogicalDatabase() || base.isNoSys());
        parameter.setPubCloud(parameter.isLogicalDatabase() || base.isPublicCloud());
        parameter.setUseServer(base.isUseServer());
    }

    private static void decryptBySecureFile(String secureFile, BaseParameter parameter) throws Exception {
        List lines;
        String security;
        if ((secureFile = secureFile.trim()).startsWith("file://")) {
            secureFile = secureFile.substring("file://".length());
        }
        if (StringUtils.isNotEmpty(security = String.join((CharSequence)"\n", lines = IOUtils.readLines((Reader)new FileReader(secureFile))))) {
            String[] array = security.split(" ");
            if (array.length < 3) {
                LogUtils.error("The security certificate file: \"{}\" has been corrupted", secureFile);
                return;
            }
            parameter.setSysUser("proxyro");
            parameter.setSysPassword(ConfigTools.decrypt((String)array[1], (String)array[2]));
        }
        LogUtils.info("The security certificate file: \"{}\" has been parsed", secureFile);
    }

    public void parseStorageConfig(String uri, BaseParameter parameter, SecureContent secureContent) {
        StorageUri storageUri = StorageUri.newFromUri(uri);
        String scheme = storageUri.getScheme();
        HashMap<String, String> uriParams = storageUri.getParameters();
        StorageType storageType = StorageType.of(scheme);
        BaseStorageConfig config = null;
        if (storageType.isCloudStorageType()) {
            String accessKey = uriParams.getOrDefault(StorageUri.UriParams.ACCESS_KEY.getName(), secureContent.getAccessKey());
            String secretKey = uriParams.getOrDefault(StorageUri.UriParams.SECRET_KEY.getName(), secureContent.getSecretKey());
            Preconditions.checkArgument((StringUtils.isNotBlank(accessKey) && StringUtils.isNotBlank(secretKey) ? 1 : 0) != 0, (Object)"Access key and secret key cannot be empty.");
            if (StorageType.AMAZON_S3 == storageType) {
                Preconditions.checkArgument((uriParams.get(StorageUri.UriParams.REGION_KEY.getName()) != null ? 1 : 0) != 0, (Object)"Invalid storage uri. S3 region is required.");
                config = S3StorageConfig.builder().region(uriParams.get(StorageUri.UriParams.REGION_KEY.getName())).storageClass(uriParams.get(StorageUri.UriParams.STORAGE_CLASS_KEY.getName())).accessKey(uriParams.getOrDefault(StorageUri.UriParams.ACCESS_KEY.getName(), secureContent.getAccessKey())).secretKey(uriParams.getOrDefault(StorageUri.UriParams.SECRET_KEY.getName(), secureContent.getSecretKey())).bucket(storageUri.getContainer()).path(storageUri.getPath()).build();
            } else if (StorageType.ALIYUN_OSS == storageType) {
                Preconditions.checkArgument((uriParams.get(StorageUri.UriParams.ENDPOINT_KEY.getName()) != null ? 1 : 0) != 0, (Object)"Invalid storage uri. OSS endpoint is required.");
                config = OssStorageConfig.builder().endpoint(uriParams.get(StorageUri.UriParams.ENDPOINT_KEY.getName())).accessKey(uriParams.getOrDefault(StorageUri.UriParams.ACCESS_KEY.getName(), secureContent.getAccessKey())).secretKey(uriParams.getOrDefault(StorageUri.UriParams.SECRET_KEY.getName(), secureContent.getSecretKey())).bucket(storageUri.getContainer()).path(storageUri.getPath()).build();
            }
        } else if (StorageType.HADOOP_HDFS == storageType) {
            config = HdfsStorageConfig.builder().path(storageUri.getPath()).authority(storageUri.getContainer()).user(uriParams.get(StorageUri.UriParams.HDFS_PRINCIPAL_KEY.getName())).keytabFile(uriParams.get(StorageUri.UriParams.HDFS_KEYTAB_PATH_KEY.getName())).hdfsUri(storageUri.getUriWithoutParam()).hdfsSiteFile(uriParams.get(StorageUri.UriParams.HDFS_SITE_FILE.getName())).coreSiteFile(uriParams.get(StorageUri.UriParams.CORE_SITE_FILE.getName())).krb5ConfFile(uriParams.get(StorageUri.UriParams.KRB5_CONF_FILE.getName())).build();
        } else {
            throw new IllegalArgumentException("Unsupported storage type: " + (Object)((Object)storageType));
        }
        parameter.setStorageConfig(config);
    }

    protected void assertParamConflict(Common.Base base) {
        boolean hasWhiteList = CollectionUtils.isNotEmpty(base.getIncludeColumnNames());
        boolean hasBlackList = CollectionUtils.isNotEmpty(base.getExcludeColumnNames()) || CollectionUtils.isNotEmpty(base.getExcludeDataTypes());
        boolean hasControlFile = StringUtils.isNotBlank(base.getCtlPath());
        Preconditions.checkArgument((!hasControlFile || !hasWhiteList && !hasBlackList ? 1 : 0) != 0, (Object)"Using both the control file and white/black list options is not allowed.");
        Preconditions.checkArgument((!hasWhiteList || !hasBlackList ? 1 : 0) != 0, (Object)"Using both the white list and black list options is not allowed.");
    }
}

