/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.cmd;

import com.oceanbase.tools.loaddump.common.enums.TaskType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import picocli.CommandLine;

public class CustomHelpSectionRenderer
implements CommandLine.IHelpSectionRenderer {
    static final Map<String, Collection<String>> DUMPER_OPTION_MAPPING = new HashMap<String, Collection<String>>();
    static final Map<String, Collection<String>> LOADER_OPTION_MAPPING = new HashMap<String, Collection<String>>();
    static final List<String> COMMON_DUMPER_OPTIONS = Arrays.asList("--ctl-path", "--snapshot", "--distinct", "--where", "--page-size", "--block-size", "--partition", "--query-sql", "--file-name", "--max-file-size", "--parallel-macro", "--retry", "--exclude-data-types", "--exclude-column-names", "--flashback-scn", "--flashback-timestamp", "--nls-date-format", "--nls-timestamp-format", "--nls-timestamp-tz-format");
    static final List<String> COMMON_LOADER_OPTIONS = Arrays.asList("--rw", "--ctl-path", "--batch", "--retry", "--slow", "--pause", "--max-tps", "--ignore-unhex", "--max-errors", "--truncate-table", "--external-data", "--max-wait-timeout", "--max-discards", "--replace-data");
    static final List<String> DUMP_SCHEMA_OPTIONS = Arrays.asList("--all", "--table", "--view", "--trigger", "--synonym", "--public-synonym", "--sequence", "--function", "--procedure", "--dblink", "--type", "--type-body", "--package", "--package-body", "--exclude-table", "--drop-object", "--add-extra-message");
    static final List<String> LOAD_SCHEMA_OPTIONS = Arrays.asList("--all", "--table", "--view", "--trigger", "--synonym", "--public-synonym", "--sequence", "--function", "--procedure", "--dblink", "--type", "--type-body", "--package", "--package-body", "--exclude-table", "--replace-object");
    private String dependent;
    private TaskType taskType;

    public CustomHelpSectionRenderer(TaskType taskType) {
        this.taskType = taskType;
    }

    private List<CommandLine.Model.OptionSpec> filter(List<CommandLine.Model.OptionSpec> optionSpecs) {
        Map<String, Collection<String>> mapping = this.taskType == TaskType.DUMP ? DUMPER_OPTION_MAPPING : LOADER_OPTION_MAPPING;
        ArrayList<CommandLine.Model.OptionSpec> shown = new ArrayList<CommandLine.Model.OptionSpec>();
        if (this.dependent == null) {
            List<String> referenced = mapping.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            shown.addAll(this.getIndependentOptions(optionSpecs, referenced));
        } else if (mapping.containsKey(this.dependent)) {
            shown.add(this.getOptionByName(optionSpecs, this.dependent));
            for (String mappedName : mapping.get(this.dependent)) {
                shown.add(this.getOptionByName(optionSpecs, mappedName));
            }
        }
        return shown;
    }

    private CommandLine.Model.OptionSpec getOptionByName(List<CommandLine.Model.OptionSpec> optionSpecs, @NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        for (CommandLine.Model.OptionSpec optionSpec : optionSpecs) {
            List<String> optionNames = Arrays.asList(optionSpec.names());
            if (!optionNames.contains(name)) continue;
            return optionSpec;
        }
        return null;
    }

    private List<CommandLine.Model.OptionSpec> getIndependentOptions(List<CommandLine.Model.OptionSpec> optionSpecs, List<String> names) {
        ArrayList<CommandLine.Model.OptionSpec> result = new ArrayList<CommandLine.Model.OptionSpec>();
        for (CommandLine.Model.OptionSpec optionSpec : optionSpecs) {
            List<String> optionNames = Arrays.asList(optionSpec.names());
            boolean isFound = false;
            for (String name : names) {
                if (!optionNames.contains(name)) continue;
                isFound = true;
            }
            if (isFound) continue;
            result.add(optionSpec);
        }
        return result;
    }

    public String render(CommandLine.Help help) {
        return help.optionListExcludingGroups(this.filter(help.commandSpec().options()));
    }

    public String getDependent() {
        return this.dependent;
    }

    public void setDependent(String dependent) {
        this.dependent = dependent;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public void setTaskType(TaskType taskType) {
        this.taskType = taskType;
    }

    static {
        DUMPER_OPTION_MAPPING.put("--ddl", DUMP_SCHEMA_OPTIONS);
        DUMPER_OPTION_MAPPING.put("--csv", CollectionUtils.union(Arrays.asList("-s", "-d", "-e", "-q", "--empty-string", "--with-trim", "--null-string", "--skip-header", "--trail-delimiter"), COMMON_DUMPER_OPTIONS));
        DUMPER_OPTION_MAPPING.put("--sql", CollectionUtils.union(Arrays.asList("--commit-size"), COMMON_DUMPER_OPTIONS));
        DUMPER_OPTION_MAPPING.put("--cut", CollectionUtils.union(Arrays.asList("--null-string", "--column-splitter", "--trail-delimiter"), COMMON_DUMPER_OPTIONS));
        LOADER_OPTION_MAPPING.put("--sql", COMMON_LOADER_OPTIONS);
        LOADER_OPTION_MAPPING.put("--mix", COMMON_LOADER_OPTIONS);
        LOADER_OPTION_MAPPING.put("--ddl", LOAD_SCHEMA_OPTIONS);
        LOADER_OPTION_MAPPING.put("--csv", CollectionUtils.union(Arrays.asList("-s", "-d", "-e", "-q", "--empty-string", "--with-trim", "--null-string", "--skip-header", "--trail", "-delimiter"), COMMON_LOADER_OPTIONS));
        LOADER_OPTION_MAPPING.put("--cut", CollectionUtils.union(Arrays.asList("--null-string", "--column-splitter", "--trail-delimiter"), COMMON_LOADER_OPTIONS));
        LOADER_OPTION_MAPPING.put("--pos", CollectionUtils.union(Arrays.asList("--null-string", "--trail-delimiter"), COMMON_LOADER_OPTIONS));
    }
}

