/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.cmd;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.oceanbase.tools.loaddump.client.LoadClient;
import com.oceanbase.tools.loaddump.client.RemoteLoadClient;
import com.oceanbase.tools.loaddump.cmd.AbstractCommandParser;
import com.oceanbase.tools.loaddump.cmd.Common;
import com.oceanbase.tools.loaddump.cmd.CustomHelpSectionRenderer;
import com.oceanbase.tools.loaddump.cmd.ObjectTypes;
import com.oceanbase.tools.loaddump.cmd.VersionProvider;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.TaskType;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.RuntimeMetrics;
import com.oceanbase.tools.loaddump.context.TaskContext;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.LogUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import com.oceanbase.tools.loaddump.vmoption.JvmArgs;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="obloader", subcommands={CommandLine.HelpCommand.class}, resourceBundle="com.oceanbase.loaddump.bundle.cli", versionProvider=VersionProvider.class, sortOptions=false, header={"@|green    ____                                  ____                       |@", "@|green   / __ \\  _____  ___   ____ _   ____    / __ )  ____ _   _____  ___ |@", "@|green  / / / / / ___/ / _ \\ / __ `/  / __ \\  / __  | / __ `/  / ___/ / _ \\|@", "@|green / /_/ / / /__  /  __// /_/ /  / / / / / /_/ / / /_/ /  (__  ) /  __/|@", "@|green \\____/  \\___/  \\___/ \\__,_/  /_/ /_/ /_____/  \\__,_/  /____/  \\___/ |@", "@|green                                                                     |@"}, footer={"%nExamples:", "@|italic \te.g: ./obloader -h 192.168.0.0 -P 2883 -u xxx -t tenantA -c ClusterA -p xxx --sys-password xxx -D USERA --ddl --all -f /Users/admin/DUMP-1/%n |@", "@|italic \te.g: ./obloader -h 192.168.0.0 -P 2883 -u xxx -t tenantA -c ClusterA -p xxx --sys-password xxx -D USERA --csv --all -f /Users/admin/DUMP-1/%n |@"})
public class Obloader
extends AbstractCommandParser
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(Obloader.class);
    @CommandLine.Option(names={"--mix"}, description={"Interpret the mix data format"})
    private boolean mix;
    @CommandLine.Option(names={"--pos"}, description={"Interpret the pos data format"})
    private boolean pos;
    @CommandLine.Option(names={"--rw"}, description={"Interpret the ratio of reader / writer"})
    private double rw = 1.0;
    @CommandLine.Option(names={"--batch"}, description={"Interpret the batch size for per insert"})
    private int batch = 200;
    @CommandLine.Option(names={"--max-tps"}, description={"Interpret the max tps for concurrent insert"})
    private int maxTps = Integer.MAX_VALUE;
    @CommandLine.Option(names={"--max-errors"}, description={"Interpret to support ignore error mode"})
    private int maxErrors = 1000;
    @CommandLine.Option(names={"--max-discards"}, description={"Interpret the threshold of discard records tolerance"})
    private int maxDiscards = 1000;
    @CommandLine.Option(names={"--strict"}, description={"Interpret that the process should exit with code 1 if there is any bad or discard record"})
    private boolean strict = true;
    @CommandLine.Option(names={"--ignore-unhex"}, description={"Interpret to ignore the unhex function"})
    private boolean ignoreUnhex;
    @CommandLine.Option(names={"--ignore-escape"}, description={"Interpret to ignore the escape data file"})
    private boolean ignoreEscape;
    @CommandLine.Option(names={"--replace-data"}, description={"Interpret to replace data of duplicated primary/unique keys"})
    private boolean replaceData;
    @CommandLine.Option(names={"--skip-footer"}, description={"Interpret to skip the last row of cut file"})
    private boolean skipFooter;
    @CommandLine.Option(names={"--slow"}, description={"Interpret the threshold to slow the writer threads"})
    private double slow = 0.75;
    @CommandLine.Option(names={"--pause"}, description={"Interpret the threshold to pause the writer threads"})
    private double pause = 0.85;
    @CommandLine.Option(names={"--replace-object"}, description={"Interpret to replace object if it exists"})
    private boolean replaceObject;
    @CommandLine.Option(names={"--truncate-table"}, description={"Interpret to truncate table before load data"})
    private boolean truncateTable;
    @CommandLine.Option(names={"--delete-from-table"}, description={"Interpret to delete from table before load data"})
    private boolean deleteFromTable;
    @CommandLine.Option(names={"--with-data-files"}, description={"Interpret to truncate table with data files before load data"})
    private boolean withDataFiles;
    @CommandLine.Option(names={"--external-data"}, description={"Interpret the data is dumped by 3rd-part tools"})
    private boolean externalData;
    @CommandLine.Option(names={"--file-regular-expression"}, description={"Interpret the regular expression of data files"})
    private String fileNameRegExp;
    @CommandLine.Option(names={"--max-wait-timeout"}, description={"If overload, the thread can wait up to N minutes"})
    private int maxWaitTimeout = 180;
    @CommandLine.Option(names={"--block-size"}, description={"Interpret the block size in MB for large file"})
    private long blockSize;
    private static final Map<Integer, String> TRUNC_OPERATION_MAP = new HashMap<Integer, String>();
    private int confirmTimes = 0;
    private static final int WITH_DATA_FILES_FLAG = 2;
    private static final int MAX_CONFIRM_TIMES = 3;
    private static final Map<Integer, String> DELETE_OPERATION_MAP;

    public static void main(String[] args) {
        Obloader loader = new Obloader();
        CommandLine cmd = new CommandLine((Object)loader);
        cmd.parseArgs(args);
        boolean isSubHelp = false;
        CustomHelpSectionRenderer custom = new CustomHelpSectionRenderer(TaskType.LOAD);
        if (args.length == 1) {
            for (String key : CustomHelpSectionRenderer.LOADER_OPTION_MAPPING.keySet()) {
                if (!key.equals(args[0].trim())) continue;
                custom.setDependent(key);
                isSubHelp = true;
                break;
            }
        }
        cmd.getHelpSectionMap().put("optionList", custom);
        cmd.setUsageHelpAutoWidth(true);
        cmd.setUsageHelpLongOptionsMaxWidth(60);
        cmd.setUsageHelpWidth(150);
        if (cmd.isUsageHelpRequested() || args.length == 0 || isSubHelp) {
            cmd.usage(cmd.getOut());
        } else if (cmd.isVersionHelpRequested()) {
            cmd.printVersionHelp(cmd.getOut());
        } else {
            loader.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.printParseArgs();
        int status = 0;
        RuntimeMetrics metrics = null;
        try {
            Stopwatch stopwatch;
            LoadParameter parameter = this.parseCommandArgs();
            if (parameter.isUseServer()) {
                if (parameter.getColumnDelimiter().charValue() == '\'') {
                    parameter.setColumnDelimiter(Character.valueOf('\"'));
                }
                RemoteLoadClient remoteLoadClient = RemoteLoadClient.builder().parameter(parameter).build();
                Stopwatch stopwatch2 = Stopwatch.createStarted();
                status = remoteLoadClient.loadRecord();
                log.info("Remote load record finished. Total Elapsed: {}", (Object)stopwatch2.stop());
                return;
            }
            LoadClient client = new LoadClient.Builder(parameter).build();
            if (JvmArgs.isBackupRestoreMode) {
                parameter.setSourceTargetTableMap(this.buildTableMapping());
            }
            DataFormat dataFormat = parameter.getDataFormat();
            Set tableSet = parameter.getWhiteListMap().getOrDefault((Object)ObjectType.TABLE, new HashSet());
            if (dataFormat != DataFormat.MIX && StringUtils.isNotBlank(parameter.getCtlPath()) && CollectionUtils.isNotEmpty((Collection)tableSet)) {
                this.parseControlFiles(parameter, tableSet);
            }
            if (parameter.isIncludeDdl() || dataFormat == DataFormat.MIX || dataFormat == DataFormat.DDL) {
                stopwatch = Stopwatch.createStarted();
                parameter.setExternal(parameter.isExternal() || DataFormat.MIX.equals((Object)dataFormat));
                status = (int)((long)status + this.waitUntilDone(client.loadSchema()));
                log.info("Load schema finished. Total Elapsed: {}", (Object)stopwatch.stop());
            }
            if (dataFormat != null && dataFormat != DataFormat.MIX && dataFormat != DataFormat.DDL) {
                stopwatch = Stopwatch.createStarted();
                TaskContext context = client.loadRecord();
                status = (int)((long)status + this.waitUntilDone(context));
                metrics = context.getRuntimeMetrics();
                log.info("Load record finished. Total Elapsed: {}", (Object)stopwatch.stop());
            }
        }
        catch (Throwable e) {
            String rootCause = ExceptionUtils.getRootCauseMessage(e);
            if (rootCause.startsWith(Constants.NO_SUBFILES) || rootCause.contains(Constants.FILE_NOT_FOUND)) {
                log.warn(rootCause);
                status = 0;
            } else {
                status = 1;
                if (JvmArgs.isMultiTask) {
                    if (JvmArgs.isDebugable) {
                        log.error("Load failed!", e);
                    } else {
                        log.error("Load failed! Error: {}", (Object)rootCause);
                    }
                } else {
                    if (JvmArgs.isDebugable) {
                        e.printStackTrace();
                    }
                    LogUtils.error("Load failed! Error: {}", rootCause);
                }
            }
        }
        finally {
            this.doFinally(metrics, status);
        }
    }

    @Override
    protected LoadParameter parseCommandArgs() throws Exception {
        String fileSuffix;
        LoadParameter parameter = new LoadParameter();
        parameter.setFailFast(false);
        super.parseCommonArgs(parameter);
        Common.Base base = this.common.getBase();
        if (this.isMix()) {
            parameter.setDataFormat(DataFormat.MIX);
        } else if (this.isPos()) {
            parameter.setDataFormat(DataFormat.POS);
        }
        ObjectTypes objects = this.common.getObjectTypes();
        DataFormat dataFormat = parameter.getDataFormat();
        if (!this.isMix()) {
            Preconditions.checkArgument((objects != null ? 1 : 0) != 0, (Object)"Option --all, --table or other object options are missing");
            parameter.getWhiteListMap().putAll(this.parseAllowedObjects(objects));
            parameter.getBlackListMap().putAll(this.parseDisallowedObjects(objects));
        }
        Set<String> tableSet = parameter.getWhiteListMap().get((Object)ObjectType.TABLE);
        if (parameter.isIncludeDdl() && dataFormat == null) {
            dataFormat = DataFormat.DDL;
            parameter.setDataFormat(dataFormat);
        }
        Preconditions.checkArgument((dataFormat != null ? 1 : 0) != 0, (String)"Option %s is missing", (Object)DataFormat.appendRecordOption());
        if (!parameter.isIncludeDdl()) {
            parameter.getWhiteListMap().clear();
            parameter.getWhiteListMap().put(ObjectType.TABLE, tableSet);
        }
        parameter.setFileSuffix(StringUtils.isNotBlank(fileSuffix = base.getFileSuffix()) ? fileSuffix : dataFormat.getDefaultFileSuffix());
        parameter.setFileNameRegExp(this.getFileNameRegExp());
        parameter.setBlockSize(this.getBlockSize() == 0L ? 0x4000000L : this.getBlockSize() * 0x100000L);
        if (StringUtils.isNotBlank(base.getCtlPath())) {
            File ctlDir = new File(base.getCtlPath());
            if (ctlDir.isFile()) {
                FileUtils.checkValidFile(ctlDir);
            } else {
                FileUtils.checkValidDirectory(ctlDir);
            }
            parameter.setCtlPath(ctlDir.getAbsolutePath());
        }
        parameter.setBatchSize(this.computeAvailableBatchSize());
        parameter.setBufferSize(this.computeAvailableBufferSize());
        parameter.setTpsLimit(this.getMaxTps());
        parameter.setMaxErrors(this.getMaxErrors());
        parameter.setSkipFooter(DataFormat.CUT.equals((Object)dataFormat) && this.isSkipFooter());
        parameter.setExternal(this.isExternalData());
        parameter.setIgnoreUnhex(this.isIgnoreUnhex());
        parameter.setIgnoreEscape(this.isIgnoreEscape());
        parameter.setReplaceData(this.isReplaceData());
        parameter.setMaxDiscards(this.getMaxDiscards());
        parameter.setStrict(this.isStrict());
        parameter.setTruncatable(this.isTruncateTable());
        parameter.setDeleteable(this.isDeleteFromTable());
        parameter.setTruncateWithDataFile(this.isWithDataFiles());
        parameter.setReplaceObjectIfExists(this.isReplaceObject());
        parameter.setMaxWaitTimeMillis(TimeUnit.MINUTES.toMillis(this.getMaxWaitTimeout()));
        parameter.setReadWriteRatio(this.getRw() < 0.0 || this.getRw() > 1.0 ? 1.0 : this.getRw());
        parameter.setSlowInsertThreshold(this.getSlow() < 0.0 || this.getSlow() > 1.0 ? 0.75 : this.getSlow());
        parameter.setPauseInsertThreshold(this.getPause() < 0.0 || this.getPause() > 1.0 ? 0.85 : this.getPause());
        return parameter;
    }

    private int computeAvailableBufferSize() {
        long maxMem = Runtime.getRuntime().maxMemory();
        if (maxMem <= 0x40000000L) {
            return 50;
        }
        if (maxMem <= 0x100000000L) {
            return 500;
        }
        if (maxMem <= 0x200000000L) {
            return 5000;
        }
        if (maxMem <= 0x400000000L) {
            return 50000;
        }
        return 500000;
    }

    private int computeAvailableBatchSize() {
        if (this.getBatch() == 200) {
            long maxMem = Runtime.getRuntime().maxMemory();
            if (maxMem <= 0x40000000L) {
                return 20;
            }
            if (maxMem <= 0x100000000L) {
                return 50;
            }
            if (maxMem <= 0x200000000L) {
                return 100;
            }
            if (maxMem <= 0x400000000L) {
                return 150;
            }
            return 200;
        }
        return Math.min(Math.max(this.getBatch(), 10), 5000);
    }

    private void confirmRiskOperation(ObjectTypes objects) throws Exception {
        if (!this.isTruncateTable() && !this.isDeleteFromTable()) {
            return;
        }
        List<String> tables = objects.getTables();
        if (!(objects.isAll() || tables.size() == 1 && STARS_WILDCARD.contains(tables.get(0)))) {
            return;
        }
        if (this.confirmTimes++ > 3) {
            throw new UnsupportedOperationException("Please confirm your risk operation");
        }
        System.out.println();
        System.out.println(StringUtils.repeat((String)"=", (int)66));
        StringBuilder sb = new StringBuilder(256);
        sb.append("\nNotice: High risk operation has been detected by the program\n\t");
        if (this.isTruncateTable()) {
            sb.append(String.join((CharSequence)"\n\t", TRUNC_OPERATION_MAP.values()));
        } else if (this.isDeleteFromTable()) {
            sb.append(String.join((CharSequence)"\n\t", DELETE_OPERATION_MAP.values()));
        }
        System.out.print(sb.append("\n\nEnter your operation (1 or 2): ").toString());
        char[] buf = new char[2];
        InputStreamReader isr = new InputStreamReader(System.in);
        int readChars = isr.read(buf);
        if (readChars < 0 || buf[0] != '1' && buf[0] != '2' || buf[1] != '\n') {
            this.confirmRiskOperation(objects);
            return;
        }
        isr.close();
        System.out.println();
        int operationNumber = Character.digit(buf[0], 10);
        if (this.isTruncateTable()) {
            LogUtils.info("Your choice is {}", TRUNC_OPERATION_MAP.get(operationNumber));
        } else if (this.isDeleteFromTable()) {
            LogUtils.info("Your choice is {}", DELETE_OPERATION_MAP.get(operationNumber));
        }
        if (operationNumber == 2 && !this.isWithDataFiles()) {
            throw new UnsupportedOperationException("Option --with-data-files is missing");
        }
    }

    public boolean isMix() {
        return this.mix;
    }

    public boolean isPos() {
        return this.pos;
    }

    public double getRw() {
        return this.rw;
    }

    public int getBatch() {
        return this.batch;
    }

    public int getMaxTps() {
        return this.maxTps;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    public int getMaxDiscards() {
        return this.maxDiscards;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isIgnoreUnhex() {
        return this.ignoreUnhex;
    }

    public boolean isIgnoreEscape() {
        return this.ignoreEscape;
    }

    public boolean isReplaceData() {
        return this.replaceData;
    }

    public boolean isSkipFooter() {
        return this.skipFooter;
    }

    public double getSlow() {
        return this.slow;
    }

    public double getPause() {
        return this.pause;
    }

    public boolean isReplaceObject() {
        return this.replaceObject;
    }

    public boolean isTruncateTable() {
        return this.truncateTable;
    }

    public boolean isDeleteFromTable() {
        return this.deleteFromTable;
    }

    public boolean isWithDataFiles() {
        return this.withDataFiles;
    }

    public boolean isExternalData() {
        return this.externalData;
    }

    public String getFileNameRegExp() {
        return this.fileNameRegExp;
    }

    public int getMaxWaitTimeout() {
        return this.maxWaitTimeout;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    static {
        TRUNC_OPERATION_MAP.put(1, "1. truncate all tables in the database");
        TRUNC_OPERATION_MAP.put(2, "2. truncate the tables with data files");
        DELETE_OPERATION_MAP = new HashMap<Integer, String>();
        DELETE_OPERATION_MAP.put(1, "1. delete from all tables in the database");
        DELETE_OPERATION_MAP.put(2, "2. delete from the tables with data files");
    }
}

