/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.constants;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Locale;

public final class JdbcType {
    public static final String BIT = "BIT";
    public static final String TINYINT = "TINYINT";
    public static final String BOOL = "BOOL";
    public static final String MEDIUMINT = "MEDIUMINT";
    public static final String DEC = "DEC";
    public static final String DATETIME = "DATETIME";
    public static final String YEAR = "YEAR";
    public static final String BINARY = "BINARY";
    public static final String TINYBLOB = "TINYBLOB";
    public static final String TINYTEXT = "TINYTEXT";
    public static final String TEXT = "TEXT";
    public static final String MEDIUMBLOB = "MEDIUMBLOB";
    public static final String MEDIUMTEXT = "MEDIUMTEXT";
    public static final String LONGBLOB = "LONGBLOB";
    public static final String LONGTEXT = "LONGTEXT";
    public static final String ENUM = "ENUM";
    public static final String SET = "SET";
    public static final String JSON = "JSON";
    public static final String NUMBER = "NUMBER";
    public static final String VARCHAR2 = "VARCHAR2";
    public static final String NVARCHAR2 = "NVARCHAR2";
    public static final String RAW = "RAW";
    public static final String LONG = "LONG";
    public static final String LONG_RAW = "LONG RAW";
    public static final String REF = "REF";
    public static final String BFILE = "BFILE";
    public static final String UROWID = "UROWID";
    public static final String XMLTYPE = "XMLType";
    public static final String BINARY_FLOAT = "BINARY_FLOAT";
    public static final String BINARY_DOUBLE = "BINARY_DOUBLE";
    public static final String REAL = "REAL";
    public static final String ROWID = "ROWID";
    public static final String FLOAT = "FLOAT";
    public static final String CHAR = "CHAR";
    public static final String NCHAR = "NCHAR";
    public static final String BLOB = "BLOB";
    public static final String CLOB = "CLOB";
    public static final String NCLOB = "NCLOB";
    public static final String DECIMAL = "DECIMAL";
    public static final String VARCHAR = "VARCHAR";
    public static final String BOOLEAN = "BOOLEAN";
    public static final String INT = "INT";
    public static final String INTEGER = "INTEGER";
    public static final String BIGINT = "BIGINT";
    public static final String SMALLINT = "SMALLINT";
    public static final String NUMERIC = "NUMERIC";
    public static final String DOUBLE = "DOUBLE";
    public static final String DECFLOAT = "DECFLOAT";
    public static final String NVARCHAR = "NVARCHAR";
    public static final String CHARACTER = "CHARACTER";
    public static final String GRAPHIC = "GRAPHIC";
    public static final String VARGRAPHIC = "VARGRAPHIC";
    public static final String LONG_VARGRAPHIC = "LONG VARGRAPHIC";
    public static final String LONG_VARCHAR = "LONG VARCHAR";
    public static final String VARG = "VARG";
    public static final String VARBINARY = "VARBINARY";
    public static final String VARBIN = "VARBIN";
    public static final String LONGVAR = "LONGVAR";
    public static final String TIMESTZ = "TIMESTZ";
    public static final String DBCLOB = "DBCLOB";
    public static final String DATE = "DATE";
    public static final String TIME = "TIME";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String TIMESTMP = "TIMESTMP";
    public static final String XML = "XML";
    public static final String DATALINK = "DATALINK";
    public static final String GEOMETRY = "GEOMETRY";
    public static final String POINT = "POINT";
    public static final String LINESTRING = "LINESTRING";
    public static final String POLYGON = "POLYGON";
    public static final String MULTIPOINT = "MULTIPOINT";
    public static final String MULTILINESTRING = "MULTILINESTRING";
    public static final String MULTIPOLYGON = "MULTIPOLYGON";
    public static final String GEOMETRYCOLLECTION = "GEOMETRYCOLLECTION";
    public static final String IMAGE = "IMAGE";
    public static final String UNICHAR = "UNICHAR";
    public static final String UNIVARCHAR = "UNIVARCHAR";
    public static final String UNITEXT = "UNITEXT";
    public static final String SMALLDATETIME = "SMALLDATETIME";
    public static final String BIGDATETIME = "BIGDATETIME";
    public static final String BIGTIME = "BIGTIME";
    public static final String SMALLMONEY = "SMALLMONEY";
    public static final String MONEY = "MONEY";
    public static final String UNSIGNED_BIGINT = "UNSIGNED BIGINT";
    public static final String UNSIGNED_INT = "UNSIGNED INT";
    public static final String UNSIGNED_SMALLINT = "UNSIGNED SMALLINT";
    public static final String NUMERIC_IDENTITY = "NUMERIC IDENTITY";

    private JdbcType() {
    }

    public static Collection<String> numerics() {
        return Lists.newArrayList((Object[])new String[]{BIT, TINYINT, SMALLINT, INT, INTEGER, MEDIUMINT, BIGINT, DOUBLE, FLOAT, DECIMAL, REAL, BINARY_FLOAT, BINARY_DOUBLE, DECFLOAT, NUMERIC, NUMBER});
    }

    public static Collection<String> strings() {
        return Lists.newArrayList((Object[])new String[]{CHAR, NCHAR, VARCHAR, NVARCHAR, CHARACTER, VARCHAR2, NVARCHAR2});
    }

    public static Collection<String> datetimes() {
        return Lists.newArrayList((Object[])new String[]{DATE, TIME, TIMESTAMP, TIMESTMP, DATETIME, YEAR});
    }

    public static boolean isNumericType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("The type is null");
        }
        return JdbcType.numerics().contains(type.toUpperCase(Locale.getDefault()));
    }

    public static boolean isStringType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("The type is null");
        }
        return JdbcType.strings().contains(type.toUpperCase(Locale.getDefault()));
    }

    public static boolean isDateType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("The type is null");
        }
        return JdbcType.datetimes().contains(type.toUpperCase(Locale.getDefault()));
    }
}

