/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.enums;

public enum StorageType {
    AMAZON_S3("s3"),
    ALIYUN_OSS("oss"),
    LOCAL_DISK("file"),
    HADOOP_HDFS("hdfs");

    public final String name;
    private static final StorageType[] STORAGE_TYPES;

    private StorageType(String name) {
        this.name = name;
    }

    public static StorageType of(String storageTypeName) {
        for (StorageType t : STORAGE_TYPES) {
            if (!t.name.equalsIgnoreCase(storageTypeName)) continue;
            return t;
        }
        throw new IllegalArgumentException("Unsupported storage type: " + storageTypeName);
    }

    public boolean isCloudStorageType() {
        return this == AMAZON_S3 || this == ALIYUN_OSS;
    }

    static {
        STORAGE_TYPES = StorageType.values();
    }
}

