/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.google.common.base.Preconditions;
import com.oceanbase.partition.calculator.ObPartIdCalculator;
import com.oceanbase.partition.calculator.enums.ObServerMode;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.partition.calculator.model.TableEntryKey;
import com.oceanbase.tools.loaddump.base.State;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.exception.ConnectFailedException;
import com.oceanbase.tools.loaddump.common.metadata.MetadataProvider;
import com.oceanbase.tools.loaddump.common.metadata.MetadataProviderV3;
import com.oceanbase.tools.loaddump.common.metadata.MetadataProviderV4;
import com.oceanbase.tools.loaddump.manager.session.SessionManager;
import com.oceanbase.tools.loaddump.utils.LogUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionKey
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ConnectionKey.class);
    public static final String ROOT_USER = "root";
    public static final String PROXYRO_USER = "proxyro";
    private static final long serialVersionUID = -3156696875930969151L;
    private static final String OBCLIENT_JDBC_URL_PREFIX = "jdbc:oceanbase://";
    private static final String MARIADB_JDBC_URL_PREFIX = "jdbc:mysql://";
    private transient State state;
    private boolean publicCloud;
    private boolean noSys;
    private String collation;
    private String host;
    private int port;
    private String cluster;
    private String tenant;
    private String username;
    private String password;
    private String database;
    private String connectDatabase;
    private transient String driverClassName;
    private String sysUser;
    private String sysPassword;
    private boolean useTraceLog = true;
    private boolean useSsl = false;
    private boolean useUnicode = true;
    private int socketTimeout = (int)TimeUnit.MINUTES.toMillis(30L);
    private int connectTimeout = (int)TimeUnit.MINUTES.toMillis(3L);
    private String characterEncoding = "utf8";
    private boolean useCompression = true;
    private boolean cachePrepStmts = true;
    private boolean noDatetimeStringSync = true;
    private boolean emulateUnsupportedPstmts = true;
    private boolean useServerPrepStmts = true;
    private boolean allowMultiQueries = true;
    private boolean rewriteBatchedStatements = true;
    private boolean useLocalSessionState = true;
    private String zeroDateTimeBehavior = "convertToNull";
    private boolean verifyServerCertificate = false;
    private boolean usePipelineAuth = false;
    private String socksProxyHost;
    private String socksProxyPort;
    private transient MetadataProvider metadataProvider;
    private transient SessionManager sessionManager;
    private ServerMode serverMode;
    private String nlsDateFormat;
    private String nlsTimestampFormat;
    private String nlsTimestampTzFormat;
    private int maxPoolSize;

    private ConnectionKey() {
    }

    public boolean hasNoSysPrivileges() {
        return this.publicCloud || this.noSys;
    }

    public String getJdbcUrl(boolean useDatabase) {
        return this.getJdbcUrl(useDatabase, true);
    }

    public String getJdbcUrl(boolean useDatabase, boolean supportBatch) {
        StringBuilder url = new StringBuilder(128);
        url.append(this.getJdbcUrl(useDatabase ? this.getConnectDatabase() : ""));
        if (supportBatch) {
            url.append("&allowMultiQueries=").append(this.isAllowMultiQueries());
            url.append("&rewriteBatchedStatements=").append(this.isRewriteBatchedStatements());
            url.append("&useLocalSessionState=").append(this.isUseLocalSessionState());
        }
        url.append("&useCompression=").append(this.isUseCompression());
        url.append("&noDatetimeStringSync=").append(this.isNoDatetimeStringSync());
        url.append("&zeroDateTimeBehavior=").append(this.getZeroDateTimeBehavior());
        url.append("&emulateUnsupportedPstmts=").append(this.isEmulateUnsupportedPstmts());
        url.append("&useServerPrepStmts=").append(this.isUseServerPrepStmts());
        return url.append("&log=").append(this.isUseTraceLog()).toString();
    }

    public String getJdbcUrl(String database) {
        boolean isCommercial = "com.oceanbase.jdbc.Driver".equalsIgnoreCase(this.getDriverClassName());
        StringBuilder url = new StringBuilder(256);
        url.append(isCommercial ? OBCLIENT_JDBC_URL_PREFIX : MARIADB_JDBC_URL_PREFIX);
        url.append(this.getHost()).append(":").append(this.getPort()).append("/");
        url.append(StringUtils.isNotBlank(database) ? database : "");
        url.append("?characterEncoding=").append(this.getCharacterEncoding());
        if (StringUtils.isNotEmpty(this.socksProxyHost) && StringUtils.isNotEmpty(this.socksProxyPort)) {
            url.append("&socksProxyHost=").append(this.getSocksProxyHost());
            url.append("&socksProxyPort=").append(this.getSocksProxyPort());
        }
        url.append("&socketTimeout=").append(this.getSocketTimeout());
        url.append("&connectTimeout=").append(this.getConnectTimeout());
        url.append("&usePipelineAuth=").append(this.isUsePipelineAuth());
        url.append("&verifyServerCertificate=").append(this.isVerifyServerCertificate());
        return url.append("&log=").append(this.isUseTraceLog()).append("&useSSL=").append(this.isUseSsl()).toString();
    }

    public String getDefaultUser() {
        return this.buildUser(this.getUsername(), this.getTenant());
    }

    public String getSysTenantUser() {
        return this.buildUser(this.getSysUser(), "sys");
    }

    private String buildUser(String user, String tenant) {
        String cluster;
        if (this.isPublicCloud()) {
            return user;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(user);
        if (StringUtils.isNotBlank(tenant)) {
            sb.append("@").append(tenant);
        }
        if (StringUtils.isNotBlank(cluster = this.getCluster())) {
            sb.append("#").append(cluster);
        }
        return sb.toString();
    }

    public SessionManager getSessionManager() {
        return this.metadataProvider.getSessionManager();
    }

    public synchronized boolean isInitialized() {
        return this.state == State.INITIAL && this.getSessionManager().isClosed();
    }

    public synchronized ConnectionKey initialize() {
        try {
            if (this.driverClassName == null) {
                this.setDriverClassName(this.detectDriverClass());
            }
            this.sessionManager = new SessionManager().init(this);
            this.metadataProvider = this.createMetadataProvider();
            this.state = State.INITIAL;
            return this;
        }
        catch (Exception e) {
            throw new ConnectFailedException("Init connection key failed. Error: {}", ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private synchronized String detectDriverClass() throws Exception {
        try {
            Class.forName("com.oceanbase.jdbc.Driver");
            LogUtils.info("Load jdbc driver class: \"{}\" finished", "com.oceanbase.jdbc.Driver");
            return "com.oceanbase.jdbc.Driver";
        }
        catch (ClassNotFoundException e1) {
            try {
                Class.forName("org.mariadb.jdbc.Driver");
                LogUtils.info("Load jdbc driver class: \"{}\" finished", "org.mariadb.jdbc.Driver");
                return "org.mariadb.jdbc.Driver";
            }
            catch (ClassNotFoundException e2) {
                throw new Exception("No-suitable jdbc driver class was found in the classpath");
            }
        }
    }

    public synchronized MetadataProvider createMetadataProvider() {
        MetadataProvider metadataProvider = this.metadataProvider;
        if (metadataProvider == null || metadataProvider.getSessionManager().isClosed()) {
            return this.serverMode.isPreviousV4() ? new MetadataProviderV3(this.sessionManager) : new MetadataProviderV4(this.sessionManager);
        }
        return metadataProvider;
    }

    public TableEntryKey createTableEntryKey(String table) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(table), (Object)"Input table is null");
        ObServerMode mode = ObServerMode.from((String)this.serverMode.name(), (String)this.serverMode.getVersion());
        return new TableEntryKey(this.cluster, this.tenant, this.database, table, mode);
    }

    public ObPartIdCalculator createPartitionIdCalculator(TableEntry tableEntry, boolean subsequentV4) {
        return new ObPartIdCalculator(this.hasNoSysPrivileges(), tableEntry, subsequentV4);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("ConnectionKey [ host: ").append(this.host);
        sb.append(", port: ").append(this.port);
        sb.append(", tenant: ").append(this.tenant);
        sb.append(", cluster: ").append(this.cluster);
        sb.append(", username: ").append(this.username);
        sb.append(", password: ******");
        sb.append(", database: ").append(this.database);
        sb.append(", connectDatabase: ").append(this.connectDatabase);
        sb.append(", sysUser: ").append(this.sysUser);
        sb.append(", sysPassword: ******");
        sb.append(", log: ").append(this.useTraceLog);
        sb.append(", useSsl: ").append(this.useSsl);
        sb.append(", useUnicode: ").append(this.useUnicode);
        sb.append(", socketTimeout: ").append(this.socketTimeout);
        sb.append(", connectTimeout: ").append(this.connectTimeout);
        sb.append(", characterEncoding: ").append(this.characterEncoding);
        sb.append(", useCompression: ").append(this.useCompression);
        sb.append(", cachePrepStmts: ").append(this.cachePrepStmts);
        sb.append(", noDatetimeStringSync: ").append(this.noDatetimeStringSync);
        sb.append(", useServerPrepStmts: ").append(this.useServerPrepStmts);
        sb.append(", allowMultiQueries: ").append(this.allowMultiQueries);
        sb.append(", rewriteBatchedStatements: ").append(this.rewriteBatchedStatements);
        sb.append(", useLocalSessionState: ").append(this.useLocalSessionState);
        sb.append(", zeroDateTimeBehavior: ").append(this.zeroDateTimeBehavior);
        sb.append(", usePipelineAuth: ").append(this.usePipelineAuth);
        sb.append(", verifyServerCertificate: ").append(this.verifyServerCertificate);
        return sb.append(" ]").toString();
    }

    public boolean isPublicCloud() {
        return this.publicCloud;
    }

    public void setPublicCloud(boolean publicCloud) {
        this.publicCloud = publicCloud;
    }

    public boolean isNoSys() {
        return this.noSys;
    }

    public void setNoSys(boolean noSys) {
        this.noSys = noSys;
    }

    public String getCollation() {
        return this.collation;
    }

    public void setCollation(String collation) {
        this.collation = collation;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getConnectDatabase() {
        return this.connectDatabase;
    }

    public void setConnectDatabase(String connectDatabase) {
        this.connectDatabase = connectDatabase;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getSysUser() {
        return this.sysUser;
    }

    public void setSysUser(String sysUser) {
        this.sysUser = sysUser;
    }

    public String getSysPassword() {
        return this.sysPassword;
    }

    public void setSysPassword(String sysPassword) {
        this.sysPassword = sysPassword;
    }

    public boolean isUseTraceLog() {
        return this.useTraceLog;
    }

    public void setUseTraceLog(boolean useTraceLog) {
        this.useTraceLog = useTraceLog;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public boolean isUseUnicode() {
        return this.useUnicode;
    }

    public void setUseUnicode(boolean useUnicode) {
        this.useUnicode = useUnicode;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public boolean isCachePrepStmts() {
        return this.cachePrepStmts;
    }

    public void setCachePrepStmts(boolean cachePrepStmts) {
        this.cachePrepStmts = cachePrepStmts;
    }

    public boolean isNoDatetimeStringSync() {
        return this.noDatetimeStringSync;
    }

    public void setNoDatetimeStringSync(boolean noDatetimeStringSync) {
        this.noDatetimeStringSync = noDatetimeStringSync;
    }

    public boolean isEmulateUnsupportedPstmts() {
        return this.emulateUnsupportedPstmts;
    }

    public void setEmulateUnsupportedPstmts(boolean emulateUnsupportedPstmts) {
        this.emulateUnsupportedPstmts = emulateUnsupportedPstmts;
    }

    public boolean isUseServerPrepStmts() {
        return this.useServerPrepStmts;
    }

    public void setUseServerPrepStmts(boolean useServerPrepStmts) {
        this.useServerPrepStmts = useServerPrepStmts;
    }

    public boolean isAllowMultiQueries() {
        return this.allowMultiQueries;
    }

    public void setAllowMultiQueries(boolean allowMultiQueries) {
        this.allowMultiQueries = allowMultiQueries;
    }

    public boolean isRewriteBatchedStatements() {
        return this.rewriteBatchedStatements;
    }

    public void setRewriteBatchedStatements(boolean rewriteBatchedStatements) {
        this.rewriteBatchedStatements = rewriteBatchedStatements;
    }

    public boolean isUseLocalSessionState() {
        return this.useLocalSessionState;
    }

    public void setUseLocalSessionState(boolean useLocalSessionState) {
        this.useLocalSessionState = useLocalSessionState;
    }

    public String getZeroDateTimeBehavior() {
        return this.zeroDateTimeBehavior;
    }

    public void setZeroDateTimeBehavior(String zeroDateTimeBehavior) {
        this.zeroDateTimeBehavior = zeroDateTimeBehavior;
    }

    public boolean isVerifyServerCertificate() {
        return this.verifyServerCertificate;
    }

    public void setVerifyServerCertificate(boolean verifyServerCertificate) {
        this.verifyServerCertificate = verifyServerCertificate;
    }

    public boolean isUsePipelineAuth() {
        return this.usePipelineAuth;
    }

    public void setUsePipelineAuth(boolean usePipelineAuth) {
        this.usePipelineAuth = usePipelineAuth;
    }

    public String getSocksProxyHost() {
        return this.socksProxyHost;
    }

    public void setSocksProxyHost(String socksProxyHost) {
        this.socksProxyHost = socksProxyHost;
    }

    public String getSocksProxyPort() {
        return this.socksProxyPort;
    }

    public void setSocksProxyPort(String socksProxyPort) {
        this.socksProxyPort = socksProxyPort;
    }

    public MetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public ServerMode getServerMode() {
        return this.serverMode;
    }

    public void setServerMode(ServerMode serverMode) {
        this.serverMode = serverMode;
    }

    public String getNlsDateFormat() {
        return this.nlsDateFormat;
    }

    public String getNlsTimestampFormat() {
        return this.nlsTimestampFormat;
    }

    public String getNlsTimestampTzFormat() {
        return this.nlsTimestampTzFormat;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public static class Builder {
        private ConnectionKey target = new ConnectionKey();

        public Builder host(String host) {
            this.target.host = host;
            return this;
        }

        public Builder port(int port) {
            this.target.port = port;
            return this;
        }

        public Builder cluster(String clusterName) {
            this.target.cluster = clusterName;
            return this;
        }

        public Builder tenant(String tenant) {
            this.target.tenant = tenant;
            return this;
        }

        public Builder username(String username) {
            this.target.username = username;
            return this;
        }

        public Builder password(String password) {
            this.target.password = password;
            return this;
        }

        public Builder database(String database) {
            this.target.database = database;
            return this;
        }

        public Builder connectDatabase(String connectDatabase) {
            this.target.connectDatabase = connectDatabase;
            return this;
        }

        public Builder pubCloud(boolean pubCloud) {
            this.target.publicCloud = pubCloud;
            return this;
        }

        public Builder noSys(boolean noSys) {
            this.target.noSys = noSys;
            return this;
        }

        public Builder sysUser(String sysUser) {
            this.target.sysUser = sysUser;
            return this;
        }

        public Builder sysPassword(String sysPassword) {
            this.target.sysPassword = sysPassword;
            return this;
        }

        public Builder log(boolean log) {
            this.target.useTraceLog = log;
            return this;
        }

        public Builder useSsl(boolean useSsl) {
            this.target.useSsl = useSsl;
            return this;
        }

        public Builder useUnicode(boolean useUnicode) {
            this.target.useUnicode = useUnicode;
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            this.target.socketTimeout = socketTimeout;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.target.connectTimeout = connectTimeout;
            return this;
        }

        public Builder characterEncoding(String characterEncoding) {
            this.target.characterEncoding = characterEncoding;
            return this;
        }

        public Builder useCompression(boolean useCompression) {
            this.target.useCompression = useCompression;
            return this;
        }

        public Builder cachePrepStmts(boolean cachePrepStatms) {
            this.target.cachePrepStmts = cachePrepStatms;
            return this;
        }

        public Builder noDatetimeStringSync(boolean noDatetimeStringSync) {
            this.target.noDatetimeStringSync = noDatetimeStringSync;
            return this;
        }

        public Builder useServerPrepStmts(boolean useServerPrepStmts) {
            this.target.useServerPrepStmts = useServerPrepStmts;
            return this;
        }

        public Builder allowMultiQueries(boolean allowMultiQueries) {
            this.target.allowMultiQueries = allowMultiQueries;
            return this;
        }

        public Builder rewriteBatchedStatements(boolean rewriteBatchedStatements) {
            this.target.rewriteBatchedStatements = rewriteBatchedStatements;
            return this;
        }

        public Builder useLocalSessionState(boolean useLocalSessionState) {
            this.target.useLocalSessionState = useLocalSessionState;
            return this;
        }

        public Builder zeroDateTimeBehavior(String zeroDateTimeBehavior) {
            this.target.zeroDateTimeBehavior = zeroDateTimeBehavior;
            return this;
        }

        public Builder verifyServerCertificate(boolean verifyServerCertificate) {
            this.target.verifyServerCertificate = verifyServerCertificate;
            return this;
        }

        public Builder usePipelineAuth(boolean usePipelineAuth) {
            this.target.usePipelineAuth = usePipelineAuth;
            return this;
        }

        public Builder socksProxyHost(String socksProxyHost) {
            this.target.socksProxyHost = socksProxyHost;
            return this;
        }

        public Builder socksProxyPort(String socksProxyPort) {
            this.target.socksProxyPort = socksProxyPort;
            return this;
        }

        public Builder nlsDateFormat(String nlsDateFormat) {
            this.target.nlsDateFormat = nlsDateFormat;
            return this;
        }

        public Builder nlsTimestampFormat(String nlsTimestampFormat) {
            this.target.nlsTimestampFormat = nlsTimestampFormat;
            return this;
        }

        public Builder nlsTimestampTzFormat(String nlsTimestampTzFormat) {
            this.target.nlsTimestampTzFormat = nlsTimestampTzFormat;
            return this;
        }

        public Builder maxPoolSize(int threads) {
            this.target.maxPoolSize = threads;
            return this;
        }

        public ConnectionKey build() {
            return this.target.initialize();
        }
    }
}

