/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.StorageType;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.TaskDetail;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.common.model.storage.BaseStorageConfig;
import com.oceanbase.tools.loaddump.parser.record.AbstractRecordParser;
import com.oceanbase.tools.loaddump.parser.record.csv.CsvFormat;
import com.oceanbase.tools.loaddump.parser.record.cut.CutRecordParserV2;
import com.oceanbase.tools.loaddump.parser.record.orc.OrcRecordParserV2;
import com.oceanbase.tools.loaddump.parser.record.par.ParquetRecordParserV2;
import com.oceanbase.tools.loaddump.parser.record.pos.Offset;
import com.oceanbase.tools.loaddump.parser.record.pos.PosRecordParser;
import com.oceanbase.tools.loaddump.parser.record.sql.SqlRecordParser;
import com.oceanbase.tools.loaddump.resource.Resource;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;

public class SubFile
implements Comparable<SubFile>,
Serializable {
    private static final long serialVersionUID = -5733534638186630854L;
    private final AtomicLong parsedCount = new AtomicLong(0L);
    private final AtomicLong loadedCount = new AtomicLong(0L);
    private final AtomicLong loadedBytes = new AtomicLong(0L);
    private final AtomicLong errorCounts = new AtomicLong(0L);
    private final transient AtomicInteger markdone = new AtomicInteger(0);
    private List<String> headers;
    private int index;
    private long offset;
    private long totalSize;
    private String message;
    private String schemaName;
    private String objectName;
    private String objectType;
    private long partitionId;
    private String filePath;
    private Resource resource;
    private DataFormat dataFormat;
    private TaskDetail taskDetail;
    private boolean visited;
    private boolean retry;
    private boolean skipHeader;
    private boolean skipFooter;
    private List<Long> errorCharPosition;
    private volatile TaskState taskState = TaskState.INITIAL;

    public SubFile() {
    }

    public SubFile(Resource resource, DataFormat format) {
        this(resource, 0, 0L, resource.getTotalSize(), format);
    }

    public SubFile(Resource resource, int index, long startPos, long endPos, DataFormat dataFormat) {
        this.resource = resource;
        this.dataFormat = dataFormat;
        this.index = index;
        this.offset = startPos;
        this.totalSize = endPos - startPos;
        this.objectType = resource.getObjectType();
        this.filePath = resource.getResourcePath();
        this.objectName = resource.getObjectName();
        this.errorCharPosition = new ArrayList<Long>();
    }

    public InputStream openBoundedStream(String fileEncoding) throws Exception {
        return this.resource.openBoundedInputStream(fileEncoding, this.offset, this.totalSize);
    }

    public AbstractRecordParser createRecordParser(LoadParameter parameter) throws Exception {
        Configuration configuration;
        String fileEncoding = parameter.getFileEncoding();
        BaseStorageConfig storageConfig = parameter.getStorageConfig();
        Configuration configuration2 = configuration = storageConfig == null ? new Configuration() : storageConfig.getHadoopConfiguration();
        if (parameter.getDataFormat() == DataFormat.CSV) {
            CsvFormat format = parameter.initCsvFormatMap().get(this.objectName);
            format = format.withSkipHeaderRecord(parameter.isSkipHeader() && this.isCanSkipFirstRecord());
            InputStream stream = this.openBoundedStream(fileEncoding);
            return format.parse(new InputStreamReader(stream, fileEncoding));
        }
        if (parameter.getDataFormat() == DataFormat.CUT) {
            this.skipFooter = parameter.isSkipFooter();
            String nullStr = parameter.getNullString();
            String splitter = parameter.getColumnSplitter();
            boolean isTrail = parameter.isTrailingDelimiter();
            boolean isTrim = parameter.isWithTrim();
            String lineSep = parameter.getLineSeparator();
            Character escape = parameter.isIgnoreEscape() ? null : parameter.getEscapeCharacter();
            InputStream stream = this.openBoundedStream(fileEncoding);
            return CutRecordParserV2.parse(stream, fileEncoding, nullStr, splitter, isTrail, escape, isTrim, lineSep, this.skipHeader);
        }
        if (parameter.getDataFormat() == DataFormat.POS) {
            String splitter = parameter.getColumnSplitter();
            boolean isTrail = parameter.isTrailingDelimiter();
            List<Offset> offsets = parameter.getControlManager().getOffsets(this.schemaName, this.objectName);
            InputStream stream = this.openBoundedStream(fileEncoding);
            return PosRecordParser.parse(stream, fileEncoding, offsets, splitter, isTrail);
        }
        if (parameter.getDataFormat() == DataFormat.SQL) {
            InputStream stream = this.openBoundedStream(fileEncoding);
            return SqlRecordParser.parse(stream, fileEncoding);
        }
        if (parameter.getDataFormat() == DataFormat.ORC) {
            return OrcRecordParserV2.parse(this.buildCloudStorageURI(storageConfig, this.filePath), configuration);
        }
        if (parameter.getDataFormat() == DataFormat.PAR) {
            return ParquetRecordParserV2.parse(this.buildCloudStorageURI(storageConfig, this.filePath), configuration);
        }
        throw new IllegalArgumentException("Unsupported data format: " + (Object)((Object)parameter.getDataFormat()));
    }

    private URI buildCloudStorageURI(BaseStorageConfig storageConfig, String filePath) throws Exception {
        if (storageConfig == null) {
            return new URI("file://" + filePath);
        }
        if (storageConfig.getStorageType() == StorageType.ALIYUN_OSS) {
            return new URI("oss://" + filePath);
        }
        if (storageConfig.getStorageType() == StorageType.AMAZON_S3) {
            return new URI("s3a://" + filePath);
        }
        if (storageConfig.getStorageType() == StorageType.HADOOP_HDFS) {
            return new URI(filePath);
        }
        throw new IllegalArgumentException("Unsupported storage type: " + (Object)((Object)storageConfig.getStorageType()));
    }

    public String getUniquePath() {
        int fileNameIdx;
        String fileName = this.filePath;
        StringBuilder sb = new StringBuilder();
        int separatorIndex = this.filePath.lastIndexOf(File.separator);
        if (separatorIndex > 0) {
            fileName = this.filePath.substring(separatorIndex);
            sb.append(this.filePath.substring(0, separatorIndex));
        }
        if ((fileNameIdx = fileName.indexOf(46)) > -1) {
            sb.append(fileName.substring(0, fileNameIdx));
        } else {
            sb.append(fileName);
        }
        if (this.index > 0) {
            sb.append("-").append(this.index);
        }
        if (fileNameIdx < 0) {
            return sb.toString();
        }
        return sb.append(fileName.substring(fileNameIdx)).toString();
    }

    public boolean isCanSkipFirstRecord() {
        return this.index < 2;
    }

    public String getObjectName() {
        if (StringUtils.isNotBlank(this.objectName)) {
            return this.objectName;
        }
        this.objectName = FileUtils.getFileNameWithoutSuffix(this.filePath);
        return this.objectName;
    }

    public void markdone() {
        this.markdone.incrementAndGet();
    }

    public void addParsedCount(int count) {
        this.parsedCount.addAndGet(count);
    }

    public void addLoadedCount(int count) {
        this.loadedCount.addAndGet(count);
    }

    public void addLoadedBytes(long bytes) {
        this.loadedBytes.addAndGet(bytes);
    }

    public void setTaskState(TaskState taskState) {
        if (taskState == null) {
            throw new IllegalArgumentException("The task state is null");
        }
        this.taskState = taskState;
    }

    public void compareAndSetState(TaskState expected, TaskState update) {
        if (this.taskState == null || this.taskState == expected) {
            this.taskState = update;
        }
    }

    public boolean isFinished() {
        return this.getTaskState().getCode() > TaskState.RUNNING.getCode();
    }

    public boolean isSuccess() {
        return this.getTaskState().getCode() == TaskState.SUCCESS.getCode();
    }

    public boolean isFailure() {
        return this.getTaskState().getCode() == TaskState.FAILURE.getCode();
    }

    public double getProgress() {
        long loadedBytes = this.getLoadedBytes().get();
        if (this.isFinished() || loadedBytes >= this.getTotalSize()) {
            return 100.0;
        }
        return new BigDecimal(100.0 * (double)loadedBytes / (double)this.getTotalSize()).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public void close() {
        if (this.resource != null) {
            try {
                this.resource.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public int compareTo(SubFile o) {
        SubFile s1 = this;
        SubFile s2 = o;
        if (s1.getTotalSize() > s2.getTotalSize()) {
            return -1;
        }
        if (s1.getTotalSize() < s2.getTotalSize()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubFile subFile = (SubFile)o;
        return this.index == subFile.index && this.offset == subFile.offset && this.totalSize == subFile.totalSize && this.partitionId == subFile.partitionId && Objects.equals(this.headers, subFile.headers) && this.schemaName.equals(subFile.schemaName) && this.objectName.equals(subFile.objectName) && this.objectType.equals(subFile.objectType) && this.filePath.equals(subFile.filePath) && this.resource.equals(subFile.resource) && this.dataFormat == subFile.dataFormat;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.headers, this.index, this.offset, this.totalSize, this.schemaName, this.objectName, this.objectType, this.partitionId, this.filePath, this.resource, this.dataFormat});
    }

    public AtomicLong getParsedCount() {
        return this.parsedCount;
    }

    public AtomicLong getLoadedCount() {
        return this.loadedCount;
    }

    public AtomicLong getLoadedBytes() {
        return this.loadedBytes;
    }

    public AtomicLong getErrorCounts() {
        return this.errorCounts;
    }

    public AtomicInteger getMarkdone() {
        return this.markdone;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<String> headers) {
        this.headers = headers;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(long partitionId) {
        this.partitionId = partitionId;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public TaskDetail getTaskDetail() {
        return this.taskDetail;
    }

    public void setTaskDetail(TaskDetail taskDetail) {
        this.taskDetail = taskDetail;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    public boolean isRetry() {
        return this.retry;
    }

    public void setRetry(boolean retry) {
        this.retry = retry;
    }

    public boolean isSkipHeader() {
        return this.skipHeader;
    }

    public void setSkipHeader(boolean skipHeader) {
        this.skipHeader = skipHeader;
    }

    public boolean isSkipFooter() {
        return this.skipFooter;
    }

    public void setSkipFooter(boolean skipFooter) {
        this.skipFooter = skipFooter;
    }

    public List<Long> getErrorCharPosition() {
        return this.errorCharPosition;
    }

    public void setErrorCharPosition(List<Long> errorCharPosition) {
        this.errorCharPosition = errorCharPosition;
    }

    public TaskState getTaskState() {
        return this.taskState;
    }
}

