/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.ColumnInfo;
import com.oceanbase.tools.loaddump.common.model.MapObject;
import com.oceanbase.tools.loaddump.factory.TypeHandlerFactory;
import com.oceanbase.tools.loaddump.function.generation.sequence.DatabaseSequence;
import com.oceanbase.tools.loaddump.mybatis.type.JdbcType;
import com.oceanbase.tools.loaddump.mybatis.type.TypeHandler;
import com.oceanbase.tools.loaddump.utils.SqlUtils;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableInfo
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(TableInfo.class);
    private static final long serialVersionUID = 535985870192322263L;
    private final Set<Integer> primaryLogicOffsets = new LinkedHashSet<Integer>(16);
    private final Set<String> primaryColumnNames = new LinkedHashSet<String>(16);
    private final List<ColumnInfo> columnInfoList = new ArrayList<ColumnInfo>(16);
    private final List<String> columnNameList = new ArrayList<String>(16);
    private final Map<String, Boolean> nullableMap = new LinkedHashMap<String, Boolean>(16);
    private final List<String> virtualColumnList = new ArrayList<String>(16);
    private final Map<String, Boolean> quotaFlagMap = new LinkedHashMap<String, Boolean>(16);
    private final Map<String, Boolean> escapeFlagMap = new LinkedHashMap<String, Boolean>(16);
    private final Map<String, Object> columnTypeMap = new LinkedHashMap<String, Object>(16);
    private final Map<String, MapObject> columnIndexMapping = new LinkedHashMap<String, MapObject>(16);
    private final Map<Integer, String> indexColumnMap = new LinkedHashMap<Integer, String>(16);
    private final Map<String, TypeHandler<?>> typeHandlerMap = new HashMap();
    private String schema;
    private String table;
    private String schemaTable;
    private String columnString;
    private ServerMode server;
    private boolean ignoreUnhex;
    private boolean logicalDatabase;
    private boolean emptyTable;
    private boolean withDatafiles;
    private String[] csvHeaders;
    private StringBuilder insertPrefix;
    private StringBuilder replacePrefix;
    private Map<Integer, String> rowKeyMap;
    private Map<Integer, String> primaryKeyMap;
    private Map<String, LinkedHashSet<String>> uniqueKeyMap;
    private static final Cache<String, String> STMT_CACHE = CacheBuilder.newBuilder().initialCapacity(64).maximumSize(8192L).softValues().concurrencyLevel(256).expireAfterAccess(5L, TimeUnit.MINUTES).removalListener(n -> log.debug("Remove the cached statement as the key has been marked: {}", (Object)n.getCause())).build();

    public TableInfo(ServerMode serverMode, String schemaName, String tableName) {
        this(serverMode, schemaName, tableName, Maps.newHashMap(), Maps.newHashMap(), Maps.newHashMap(), false);
    }

    public TableInfo(ServerMode serverMode, String schemaName, String tableName, Map<String, ColumnInfo> columnMap, Map<String, MapObject> columnIndexMap, Map<String, TypeHandler<?>> typeHandlerMap, boolean dumpOperation) {
        this.server = serverMode;
        this.schema = schemaName;
        this.table = tableName;
        this.typeHandlerMap.putAll(typeHandlerMap);
        this.initializeTableInfoMetadata(columnMap, columnIndexMap, dumpOperation);
        this.buildSqlPrefix(dumpOperation);
        this.csvHeaders = this.columnNameList.toArray(new String[0]);
    }

    public void resetTableInfo(ResultSet rs, ServerMode serverMode, boolean isUseRunTimeName, boolean preserveZeroDatetime) throws SQLException {
        this.server = serverMode;
        ResultSetMetaData rsmd = rs.getMetaData();
        for (int i = 0; i < rsmd.getColumnCount(); ++i) {
            String columnName = isUseRunTimeName ? rsmd.getColumnName(i + 1) : rsmd.getColumnLabel(i + 1);
            String dataType = rsmd.getColumnTypeName(i + 1);
            dataType = dataType == null ? JdbcType.VARCHAR.name().toLowerCase(Locale.getDefault()) : dataType.toLowerCase(Locale.getDefault());
            ColumnInfo columnInfo = new ColumnInfo(columnName, dataType, i);
            columnInfo.setSchemaName(rsmd.getCatalogName(i + 1));
            columnInfo.setTableName(rsmd.getTableName(i + 1));
            this.fillingColumnInfoMetadata(columnInfo);
            this.columnIndexMapping.put(columnName, new MapObject(i, i));
            this.typeHandlerMap.put(columnName, TypeHandlerFactory.createTypeHandler(dataType, ServerMode.MYSQL.equals((Object)serverMode), preserveZeroDatetime));
        }
        this.columnString = this.buildColumnString(true);
        this.buildSqlPrefix(true);
    }

    private void initializeTableInfoMetadata(@NonNull Map<String, ColumnInfo> columnInfoMap, Map<String, MapObject> columnIndexMap, boolean dumpOperation) {
        if (columnInfoMap == null) {
            throw new NullPointerException("columnInfoMap is marked non-null but is null");
        }
        Collection<ColumnInfo> columnInfos = columnInfoMap.values();
        if (MapUtils.isNotEmpty(columnIndexMap)) {
            int logicOffset = 0;
            for (Map.Entry<String, MapObject> entry : columnIndexMap.entrySet()) {
                for (ColumnInfo columnInfo : columnInfos) {
                    if (!columnInfo.getColumnName().equals(entry.getKey())) continue;
                    MapObject mapObj = entry.getValue();
                    if (mapObj.getSource() == null && (dumpOperation || mapObj.getGeneratedDefine() == null)) {
                        mapObj.setSource(logicOffset++);
                    }
                    this.fillingColumnInfoMetadata(columnInfo);
                }
            }
        } else {
            int logicOffset = 0;
            for (ColumnInfo columnInfo : columnInfos) {
                columnIndexMap.put(columnInfo.getColumnName(), new MapObject(logicOffset++, columnInfo.getColumnPosition()));
                this.fillingColumnInfoMetadata(columnInfo);
            }
        }
        this.columnIndexMapping.putAll(columnIndexMap);
    }

    private void fillingColumnInfoMetadata(ColumnInfo columnInfo) {
        String columnName = columnInfo.getColumnName();
        Object dataType = columnInfo.getDataType();
        Integer physicOffset = columnInfo.getColumnPosition();
        this.columnInfoList.add(columnInfo);
        this.columnNameList.add(columnName);
        this.columnTypeMap.put(columnName, dataType);
        this.indexColumnMap.put(physicOffset, columnName);
        this.nullableMap.put(columnName, columnInfo.isNullable());
        if (columnInfo.isVirtual()) {
            this.virtualColumnList.add(columnName);
        }
        this.quotaFlagMap.put(columnName, this.server.isNeedQuote(dataType.toString()));
        this.escapeFlagMap.put(columnName, this.server.isNeedEscape(dataType.toString()));
    }

    private void buildSqlPrefix(boolean dumpOperation) {
        String table = this.getTable();
        String columnString = this.buildColumnString(dumpOperation);
        int capacity = 16 + table.length() + columnString.length();
        this.insertPrefix = new StringBuilder(capacity).append("INSERT INTO ").append(table).append(" (").append(columnString).append(")");
        if (!dumpOperation) {
            this.replacePrefix = new StringBuilder(capacity).append("REPLACE INTO ").append(table).append(" (").append(columnString).append(")");
        }
    }

    public String buildColumnString(boolean includeVirtual) {
        if (StringUtils.isNotEmpty((CharSequence)this.columnString)) {
            return this.columnString;
        }
        StringBuilder sb = new StringBuilder(this.columnNameList.size() * 32);
        for (String columnName : this.columnNameList) {
            if (!includeVirtual && this.isVirtualColumn(columnName)) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.server.wrapName(columnName));
        }
        this.columnString = sb.toString();
        return this.columnString;
    }

    public void preparePrimary() {
        if (this.primaryLogicOffsets.isEmpty() && !this.primaryKeyMap.isEmpty()) {
            for (Map.Entry<Integer, String> entry : this.primaryKeyMap.entrySet()) {
                Integer ordinalPosition = entry.getKey();
                String columnName = entry.getValue();
                Integer logicOffset = this.getLogicOffset(columnName);
                if (logicOffset == null) {
                    log.warn("The logic offset of primary key column: [{},\"{}\"] is null. Maybe the primary key data doesn't exist in the data file.", (Object)ordinalPosition, (Object)columnName);
                    break;
                }
                this.primaryLogicOffsets.add(logicOffset);
                this.primaryColumnNames.add(entry.getValue());
            }
        }
    }

    public Integer getLogicOffset(String columnName) {
        if (MapUtils.isNotEmpty(this.columnIndexMapping) && MapUtils.isNotEmpty(this.columnIndexMapping)) {
            MapObject obj = this.columnIndexMapping.get(columnName);
            return obj == null ? null : obj.getSource();
        }
        return null;
    }

    public Integer getPhysicalOffset(String columnName) {
        if (MapUtils.isNotEmpty(this.columnIndexMapping)) {
            MapObject obj = this.columnIndexMapping.get(columnName);
            return obj == null ? null : obj.getTarget();
        }
        return null;
    }

    public Collection<Integer> getLogicOffsets() {
        return this.columnIndexMapping.values().stream().map(MapObject::getSource).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String cachedSqlStmt(int valueSize, int recordCount) {
        String key = this.getSchemaTable() + "_" + valueSize + "_" + recordCount;
        try {
            return (String)STMT_CACHE.get((Object)key, () -> {
                String placeholder = this.assemblePlaceholders(valueSize);
                String placeHolder = StringUtils.repeat((String)("(" + placeholder + ")"), (String)",", (int)recordCount);
                return this.getInsertPrefix() + " VALUES " + placeHolder;
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Get cached sql statement failed. Table: " + this.getSchemaTable(), e);
        }
    }

    public String getRetriedInsertSqlStmt(int valueSize) {
        String placeholder = this.assemblePlaceholders(valueSize);
        StringBuilder insertPrefix = this.getInsertPrefix();
        String schemaTable = this.getSchemaTable();
        int capacity = insertPrefix.length() + 256;
        capacity += placeholder.length() + schemaTable.length() + this.primaryKeyMap.size();
        StringBuilder sql = new StringBuilder(capacity += this.primaryKeyMap.size() * 10);
        sql.append((CharSequence)this.getInsertPrefix());
        sql.append(" SELECT ").append(placeholder).append(" FROM DUAL");
        sql.append(" WHERE NOT EXISTS (SELECT 1 FROM ").append(schemaTable);
        sql.append(" WHERE ");
        sql.append(this.primaryKeyMap.values().stream().map(p -> p + "=?").collect(Collectors.joining(" AND ")));
        sql.append(")");
        return sql.toString();
    }

    private String assemblePlaceholders(int valueSize) {
        StringBuilder placeHolders = new StringBuilder(valueSize * 2);
        for (int logicPosition = 0; logicPosition < valueSize; ++logicPosition) {
            boolean isUseUnhex;
            Integer offset = this.getPhysicOffset(logicPosition);
            if (offset == null || this.isVirtualColumn(logicPosition)) continue;
            if (placeHolders.length() > 0) {
                placeHolders.append(",");
            }
            String dataType = this.getColumnTypeName(logicPosition);
            String columnName = this.getColumnNameList().get(logicPosition);
            boolean bl = isUseUnhex = this.isMySqlMode() && !this.isIgnoreUnhex();
            if (isUseUnhex && SqlUtils.isBinaryType(dataType)) {
                placeHolders.append("unhex(?)");
                continue;
            }
            if ("YEAR".equalsIgnoreCase(dataType)) {
                placeHolders.append("CAST( ? AS UNSIGNED)");
                continue;
            }
            if (this.containsDbSequence(columnName)) {
                DatabaseSequence dbSequence = (DatabaseSequence)this.getColumnIndexMapping().get(columnName).getGeneratedDefine();
                placeHolders.append(dbSequence.getValue());
                continue;
            }
            placeHolders.append("?");
        }
        return placeHolders.toString();
    }

    public Object getColumnType(int logicPosition) {
        String columnName = this.getColumnNameList().get(logicPosition);
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)columnName), (String)"Column name is empty. table: %s, logic pos: %s", (Object)this.getTable(), (int)logicPosition);
        Object columnType = this.getColumnType(columnName);
        Preconditions.checkState((columnType != null ? 1 : 0) != 0, (String)"Column type is null. table: %s, column name: %s, logic pos: %s", (Object)this.getTable(), (Object)columnName, (Object)logicPosition);
        return columnType;
    }

    public String getColumnTypeName(int logicPosition) {
        return this.getColumnType(logicPosition).toString();
    }

    public Integer getPhysicOffset(int logicPosition) {
        if (logicPosition >= this.getColumnNameList().size()) {
            return null;
        }
        String columnName = this.getColumnNameList().get(logicPosition);
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)columnName), (String)"Column name is empty. table: %s, logic pos: %s", (Object)this.getTable(), (int)logicPosition);
        MapObject mapObject = this.columnIndexMapping.get(columnName);
        Preconditions.checkState((mapObject != null ? 1 : 0) != 0, (String)"Column map object is null. table: %s, column name: %s, logic pos: %s", (Object)this.getTable(), (Object)columnName, (Object)logicPosition);
        return mapObject.getTarget();
    }

    public Object getColumnType(String columnName) {
        return this.columnTypeMap.get(columnName);
    }

    public String getColumnTypeName(String columnName) {
        return this.getColumnType(columnName).toString();
    }

    public String getSchemaTable() {
        if (this.schemaTable != null) {
            return this.schemaTable;
        }
        StringBuilder sb = new StringBuilder(this.schema.length() + this.table.length() + 16);
        sb.append(this.server.wrapName(this.getSchema())).append(".").append(this.server.wrapName(this.getTable()));
        this.schemaTable = sb.toString();
        return this.schemaTable;
    }

    public boolean isNeedEscape(int logicPosition) {
        Integer physicalOffset = this.getPhysicOffset(logicPosition);
        Preconditions.checkState((physicalOffset != null ? 1 : 0) != 0, (String)"The physical offset is null. logic pos: %s, table: %s", (Object)this.getTable(), (int)logicPosition);
        return this.isNeedEscape(this.indexColumnMap.get(physicalOffset));
    }

    public boolean isNeedEscape(String columnName) {
        return this.escapeFlagMap.get(columnName);
    }

    public boolean isNeedQuote(int logicPosition) {
        Integer physicalOffset = this.getPhysicOffset(logicPosition);
        Preconditions.checkState((physicalOffset != null ? 1 : 0) != 0, (String)"The physical offset is null. table: %s, logic pos: %s, ", (Object)this.getTable(), (int)logicPosition);
        return this.isNeedQuote(this.indexColumnMap.get(physicalOffset));
    }

    public boolean isNeedQuote(@NonNull String columnName) {
        if (columnName == null) {
            throw new NullPointerException("columnName is marked non-null but is null");
        }
        return this.quotaFlagMap.get(columnName);
    }

    public boolean isNullable(int logicPosition) {
        Integer physicalOffset = this.getPhysicOffset(logicPosition);
        Preconditions.checkState((physicalOffset != null ? 1 : 0) != 0, (String)"The physical offset is null. table: %s, logic pos: %s, ", (Object)this.getTable(), (int)logicPosition);
        return this.isNullable(this.indexColumnMap.get(physicalOffset));
    }

    public boolean isNullable(@NonNull String columnName) {
        if (columnName == null) {
            throw new NullPointerException("columnName is marked non-null but is null");
        }
        return this.nullableMap.get(columnName);
    }

    public boolean isMySqlMode() {
        return ServerMode.MYSQL.equals((Object)this.getServer());
    }

    public boolean isOracleMode() {
        return ServerMode.ORACLE.equals((Object)this.getServer());
    }

    public boolean isVirtualColumn(int logicPosition) {
        return this.isVirtualColumn(this.getColumnNameList().get(logicPosition));
    }

    public boolean isVirtualColumn(String columnName) {
        List<String> virtualColumns = this.getVirtualColumnList();
        return CollectionUtils.isNotEmpty(virtualColumns) && virtualColumns.contains(columnName);
    }

    public TypeHandler<?> getTypeHandler(String columnName) {
        return this.typeHandlerMap.get(columnName);
    }

    public void buildReplaceIntoPrefix() {
        this.insertPrefix = this.replacePrefix;
    }

    public boolean hasPrimaryKey() {
        return !this.primaryLogicOffsets.isEmpty();
    }

    public boolean hasUniqueKey() {
        return this.uniqueKeyMap != null && !this.uniqueKeyMap.isEmpty();
    }

    public boolean containsDbSequence(String columnName) {
        Map<String, MapObject> colIdxMapping = this.getColumnIndexMapping();
        if (MapUtils.isEmpty(colIdxMapping)) {
            return false;
        }
        MapObject mapObject = colIdxMapping.get(columnName);
        if (mapObject == null) {
            return false;
        }
        return mapObject.getGeneratedDefine() instanceof DatabaseSequence;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableInfo tableInfo = (TableInfo)o;
        return Objects.equals(this.schema, tableInfo.schema) && Objects.equals(this.table, tableInfo.table);
    }

    public String toString() {
        return "TableInfo{schema='" + this.schema + '\'' + ", table='" + this.table + '\'' + '}';
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.table);
    }

    public TableInfo() {
    }

    public Set<Integer> getPrimaryLogicOffsets() {
        return this.primaryLogicOffsets;
    }

    public Set<String> getPrimaryColumnNames() {
        return this.primaryColumnNames;
    }

    public List<ColumnInfo> getColumnInfoList() {
        return this.columnInfoList;
    }

    public List<String> getColumnNameList() {
        return this.columnNameList;
    }

    public List<String> getVirtualColumnList() {
        return this.virtualColumnList;
    }

    public Map<String, Object> getColumnTypeMap() {
        return this.columnTypeMap;
    }

    public Map<String, MapObject> getColumnIndexMapping() {
        return this.columnIndexMapping;
    }

    public Map<Integer, String> getIndexColumnMap() {
        return this.indexColumnMap;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public ServerMode getServer() {
        return this.server;
    }

    public boolean isIgnoreUnhex() {
        return this.ignoreUnhex;
    }

    public void setIgnoreUnhex(boolean ignoreUnhex) {
        this.ignoreUnhex = ignoreUnhex;
    }

    public boolean isLogicalDatabase() {
        return this.logicalDatabase;
    }

    public void setLogicalDatabase(boolean logicalDatabase) {
        this.logicalDatabase = logicalDatabase;
    }

    public boolean isEmptyTable() {
        return this.emptyTable;
    }

    public void setEmptyTable(boolean emptyTable) {
        this.emptyTable = emptyTable;
    }

    public boolean isWithDatafiles() {
        return this.withDatafiles;
    }

    public void setWithDatafiles(boolean withDatafiles) {
        this.withDatafiles = withDatafiles;
    }

    public String[] getCsvHeaders() {
        return this.csvHeaders;
    }

    public StringBuilder getInsertPrefix() {
        return this.insertPrefix;
    }

    public void setInsertPrefix(StringBuilder insertPrefix) {
        this.insertPrefix = insertPrefix;
    }

    public StringBuilder getReplacePrefix() {
        return this.replacePrefix;
    }

    public void setReplacePrefix(StringBuilder replacePrefix) {
        this.replacePrefix = replacePrefix;
    }

    public Map<Integer, String> getRowKeyMap() {
        return this.rowKeyMap;
    }

    public void setRowKeyMap(Map<Integer, String> rowKeyMap) {
        this.rowKeyMap = rowKeyMap;
    }

    public Map<Integer, String> getPrimaryKeyMap() {
        return this.primaryKeyMap;
    }

    public void setPrimaryKeyMap(Map<Integer, String> primaryKeyMap) {
        this.primaryKeyMap = primaryKeyMap;
    }

    public Map<String, LinkedHashSet<String>> getUniqueKeyMap() {
        return this.uniqueKeyMap;
    }

    public void setUniqueKeyMap(Map<String, LinkedHashSet<String>> uniqueKeyMap) {
        this.uniqueKeyMap = uniqueKeyMap;
    }
}

