/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model.storage.remote.cloud;

import com.oceanbase.tools.loaddump.common.enums.StorageType;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.AbstractCloudStorageConfig;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import org.apache.hadoop.conf.Configuration;

public class OssStorageConfig
extends AbstractCloudStorageConfig {
    private String endpoint;

    @Override
    public StorageType getStorageType() {
        return StorageType.ALIYUN_OSS;
    }

    @Override
    public Configuration getHadoopConfiguration() {
        Configuration conf = new Configuration();
        conf.set("fs.oss.endpoint", this.endpoint);
        conf.set("fs.oss.accessKeyId", this.accessKey);
        conf.set("fs.oss.accessKeySecret", this.secretKey);
        conf.set("fs.oss.impl", "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem");
        return conf;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public static class Builder {
        OssStorageConfig target = new OssStorageConfig();

        public Builder endpoint(String endpoint) {
            this.target.endpoint = endpoint;
            return this;
        }

        public Builder bucket(String bucket) {
            this.target.bucket = bucket;
            return this;
        }

        public Builder accessKey(String accessKey) {
            this.target.accessKey = accessKey;
            return this;
        }

        public Builder secretKey(String secretKey) {
            this.target.secretKey = secretKey;
            return this;
        }

        public Builder aclString(String aclString) {
            this.target.aclString = aclString;
            return this;
        }

        public Builder path(String path) {
            this.target.path = path;
            return this;
        }

        public OssStorageConfig build() {
            this.target.uri = FileUtils.toPath("oss://", this.target.bucket, this.target.path);
            return this.target;
        }
    }
}

