/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.task;

import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.enums.UploadBehavior;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.TaskDetail;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.dumper.uploader.AsyncFileUploader;
import com.oceanbase.tools.loaddump.factory.FileUploaderFactory;
import com.oceanbase.tools.loaddump.manager.session.SessionManager;
import com.oceanbase.tools.loaddump.manager.session.SessionOption;
import com.oceanbase.tools.loaddump.manager.session.SessionProperties;
import com.oceanbase.tools.loaddump.reader.AbstractDatabaseReader;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.SerializeUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDumpTask
extends AbstractDatabaseReader
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(AbstractDumpTask.class);
    private static final long serialVersionUID = 5921786708138983445L;
    protected volatile TaskState taskState = TaskState.INITIAL;
    protected transient String message;
    protected volatile long totalCount;
    protected volatile long recordCount;
    protected String schemaName;
    protected String objectType;
    protected String objectName;
    protected String partitionName;
    protected String dataPath;
    protected String fileEncoding;
    protected String checkpointPath;
    protected ServerMode serverMode;
    protected TaskDetail taskDetail;
    protected AtomicBoolean supervisor;
    protected transient ConnectionKey connectionKey;
    protected transient SessionManager sessionManager;
    protected ConcurrentHashMap<String, AtomicLong> limitDumpMap;
    protected ConcurrentHashMap<String, AtomicLong> identicalNoMap;
    protected transient List<? extends AbstractDumpTask> dumpTasks;
    protected transient AsyncFileUploader asyncFileUploader;

    public void initialize(DumpParameter parameter) throws Exception {
        this.dataPath = parameter.getDataPath();
        this.schemaName = parameter.getDatabaseName();
        this.fileEncoding = parameter.getFileEncoding();
        this.serverMode = parameter.getDatabase().getServerMode();
        this.connectionKey = parameter.getConnectionKey();
        this.sessionManager = parameter.getConnectionKey().getSessionManager();
        if (UploadBehavior.FAST.equals((Object)parameter.getUploadBehavior())) {
            this.asyncFileUploader = new AsyncFileUploader(FileUploaderFactory.createFileUploader(parameter.getStorageConfig(), parameter.getFilePath()));
            this.asyncFileUploader.setUploadTask(this.taskDetail.getUploadTask());
        }
    }

    protected SessionOption buildSessionOption() {
        return SessionOption.join(SessionOption.withEncoding(SessionProperties.getString("jdbc.url.character.encoding")), SessionOption.withTrxTimeout(SessionProperties.hourToMicros("ob.trx.timeout.for.dump.record")), SessionOption.withQueryTimeout(SessionProperties.hourToMicros("ob.query.timeout.for.dump.record")), SessionOption.withNetReadTimeout(SessionProperties.hourToSeconds("ob.net.read.timeout.for.dump.record")), SessionOption.withNetWriteTimeout(SessionProperties.hourToSeconds("ob.net.write.timeout.for.dump.record")), SessionOption.withSelectLimit(Long.MAX_VALUE));
    }

    public String getTablePartition() {
        StringBuilder sb = new StringBuilder(64);
        if (StringUtils.isNotBlank(this.schemaName)) {
            sb.append(this.schemaName).append(".");
        }
        if (StringUtils.isNotBlank(this.objectName)) {
            sb.append(this.objectName);
        }
        if (StringUtils.isNotBlank(this.partitionName)) {
            sb.append(".").append(this.partitionName);
        }
        return sb.toString();
    }

    public abstract String buildOutputPath();

    protected abstract void updateTaskDetail();

    protected void updateCheckpoint() {
        if (StringUtils.isBlank(this.checkpointPath)) {
            log.warn("The checkpoint file path is null.");
            return;
        }
        try {
            SerializeUtils.serializeListByKryoSafely(this.dumpTasks, this.checkpointPath);
        }
        catch (Exception e) {
            log.error("Update checkpoint: \"{}\". Error: {}", (Object)this.checkpointPath, (Object)ExceptionUtils.getRootCauseMessage(e));
        }
    }

    protected void uploadIfNeeded(String file) {
        if (this.asyncFileUploader != null) {
            this.asyncFileUploader.submitUpload(new File(file));
        }
    }

    protected void waitUntilDone() {
        if (this.asyncFileUploader == null) {
            this.updateTaskState(TaskState.SUCCESS);
            return;
        }
        this.updateTaskState(TaskState.UPLOADING);
        this.asyncFileUploader.waitUntilDone();
        if (this.taskDetail.getUploadTask().isFailure()) {
            this.updateTaskState(TaskState.FAILURE);
        } else {
            this.updateTaskState(TaskState.SUCCESS);
        }
    }

    protected void updateTaskState(TaskState taskState) {
        if (this.taskState != TaskState.FAILURE) {
            this.taskState = taskState;
        }
    }

    public boolean isFinished() {
        return this.taskState.getCode() > TaskState.RUNNING.getCode();
    }

    public boolean isSuccess() {
        return this.taskState.getCode() == TaskState.SUCCESS.getCode();
    }

    public boolean isFailure() {
        return this.taskState.getCode() == TaskState.FAILURE.getCode();
    }

    public TaskState getTaskState() {
        return this.taskState;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setCheckpointPath(String checkpointPath) {
        this.checkpointPath = checkpointPath;
    }

    public TaskDetail getTaskDetail() {
        return this.taskDetail;
    }

    public void setTaskDetail(TaskDetail taskDetail) {
        this.taskDetail = taskDetail;
    }

    public void setSupervisor(AtomicBoolean supervisor) {
        this.supervisor = supervisor;
    }

    public void setLimitDumpMap(ConcurrentHashMap<String, AtomicLong> limitDumpMap) {
        this.limitDumpMap = limitDumpMap;
    }

    public void setIdenticalNoMap(ConcurrentHashMap<String, AtomicLong> identicalNoMap) {
        this.identicalNoMap = identicalNoMap;
    }

    public void setDumpTasks(List<? extends AbstractDumpTask> dumpTasks) {
        this.dumpTasks = dumpTasks;
    }

    public AsyncFileUploader getAsyncFileUploader() {
        return this.asyncFileUploader;
    }

    public void setAsyncFileUploader(AsyncFileUploader asyncFileUploader) {
        this.asyncFileUploader = asyncFileUploader;
    }
}

