/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.task.record;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.TaskType;
import com.oceanbase.tools.loaddump.common.model.ColumnInfo;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.RangeKey;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.common.model.TableRangeInfo;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.dumper.assembler.AbstractStatementAssembler;
import com.oceanbase.tools.loaddump.dumper.task.AbstractDumpTask;
import com.oceanbase.tools.loaddump.dumper.translator.AbstractRecordTranslator;
import com.oceanbase.tools.loaddump.dumper.translator.ColRecordTranslator;
import com.oceanbase.tools.loaddump.dumper.translator.CsvRecordTranslator;
import com.oceanbase.tools.loaddump.dumper.translator.CutRecordTranslator;
import com.oceanbase.tools.loaddump.dumper.translator.SqlRecordTranslator;
import com.oceanbase.tools.loaddump.function.AbstractUserDefinedFunction;
import com.oceanbase.tools.loaddump.function.SqlFunction;
import com.oceanbase.tools.loaddump.function.context.ControlDescription;
import com.oceanbase.tools.loaddump.manager.ControlManager;
import com.oceanbase.tools.loaddump.manager.session.SessionOption;
import com.oceanbase.tools.loaddump.manager.session.SessionProperties;
import com.oceanbase.tools.loaddump.metrics.Meter;
import com.oceanbase.tools.loaddump.parser.record.csv.CsvFormat;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.JdbcUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import com.oceanbase.tools.loaddump.vmoption.JvmArgs;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingFileWriter;
import com.oceanbase.tools.loaddump.writer.file.DefaultFileWriter;
import com.oceanbase.tools.loaddump.writer.file.OrcFileWriterV2;
import com.oceanbase.tools.loaddump.writer.file.ParquetFileWriterV2;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordDumpTask
extends AbstractDumpTask {
    private static final Logger log = LoggerFactory.getLogger(RecordDumpTask.class);
    private static final long serialVersionUID = 2223238398433917159L;
    protected int groupNo;
    protected long blockSize;
    protected String blockSizeUnit;
    protected int commitSize;
    protected boolean weakRead;
    @Deprecated
    protected long maxFileSize;
    protected int fetchSize;
    protected boolean emptyTable;
    protected boolean customQuery;
    protected boolean retainEmptyFile;
    protected String fileSuffix;
    protected boolean needFileHeader;
    protected TableRangeInfo tableRangeInfo;
    protected boolean preserveZeroDatetime;
    protected String nlsDateFormat = "YYYY-MM-DD HH24:MI:SS";
    protected String nlsTimestampFormat = "YYYY-MM-DD HH24:MI:SS:FF9";
    protected String nlsTimestampTzFormat = "YYYY-MM-DD HH24:MI:SS:FF9";
    protected transient Meter meter;
    protected transient CsvFormat csvFormat;
    protected transient AbstractStatementAssembler assembler;
    protected transient AbstractRollingFileWriter fileWriter;
    protected transient AbstractRecordTranslator recordTranslator;
    protected transient Cache<String, PreparedStatement> pstmtCache = CacheBuilder.newBuilder().initialCapacity(64).maximumSize(8192L).softValues().concurrencyLevel(256).expireAfterAccess(5L, TimeUnit.MINUTES).removalListener(n -> {
        JdbcUtils.close((AutoCloseable)n.getValue());
        log.debug("Remove the cached prepared statement as the key has been marked: {}", (Object)n.getCause());
    }).build();

    public RecordDumpTask() {
    }

    public RecordDumpTask(String tableName, AbstractStatementAssembler assembler) {
        this(tableName, 0, assembler);
    }

    public RecordDumpTask(boolean emptyTable, String tableName, AbstractStatementAssembler assembler) {
        this(tableName, assembler);
        this.emptyTable = emptyTable;
    }

    public RecordDumpTask(String tableName, int groupNo, AbstractStatementAssembler assembler) {
        this(tableName, groupNo, assembler, false);
    }

    public RecordDumpTask(String tableName, int groupNo, AbstractStatementAssembler assembler, boolean emptyTable) {
        this.emptyTable = emptyTable;
        this.assembler = assembler;
        this.groupNo = groupNo;
        this.maxFileSize = assembler.getParameter().getMaxFileSize();
        this.tableRangeInfo = assembler.getTableRangeInfo();
        this.totalCount = this.maxFileSize > 0L ? this.maxFileSize : 1L;
        this.schemaName = assembler.getParameter().getDatabaseName();
        this.objectName = tableName;
    }

    @Override
    public void initialize(DumpParameter parameter) throws Exception {
        super.initialize(parameter);
        this.weakRead = parameter.isWeakRead();
        this.nlsDateFormat = parameter.getNlsDateFormat();
        this.nlsTimestampFormat = parameter.getNlsTimestampFormat();
        this.nlsTimestampTzFormat = parameter.getNlsTimestampTzFormat();
        this.blockSize = parameter.getBlockSize();
        this.blockSizeUnit = parameter.getBlockSizeUnit();
        this.commitSize = parameter.getCommitSize();
        this.fetchSize = parameter.getFetchSize();
        this.checkpointPath = parameter.getCheckpointPath();
        DataFormat dataFormat = parameter.getDataFormat();
        this.needFileHeader = dataFormat == DataFormat.CSV;
        this.recordTranslator = this.createRecordTranslator(parameter);
        if (parameter.isRetry()) {
            this.assembler.setParameter(parameter);
        }
        this.customQuery = StringUtils.isNotBlank(parameter.getQuerySql());
        this.fileSuffix = parameter.getFileSuffix();
        this.retainEmptyFile = parameter.isRetainEmptyFiles();
        this.preserveZeroDatetime = parameter.isPreserveZeroDatetime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.updateTaskState(TaskState.RUNNING);
            if (this.emptyTable) {
                if (this.retainEmptyFile) {
                    this.createEmptyFile(this.fileSuffix);
                }
            } else {
                SessionOption sessionOpts = this.buildSessionOption();
                try (Connection conn = this.sessionManager.createNewConnection(true, true, sessionOpts);){
                    long totalCount = 0L;
                    totalCount = this.maxFileSize > 0L ? this.executeSync(conn, this.assembler.assembleQuerySql()) : this.executeUnsync(conn, this.assembler.assembleQuerySql());
                    if (totalCount > 0L) {
                        this.recordCount = totalCount;
                        log.info("Dump {} rows {} to \"{}\" finished", new Object[]{totalCount, this.getTablePartition(), this.buildOutputPath()});
                    }
                }
            }
            this.waitUntilDone();
        }
        catch (Exception e) {
            this.updateTaskState(TaskState.FAILURE);
            this.message = ExceptionUtils.getRootCauseMessage(e);
            log.error("Dump {} to \"{}\" failed", new Object[]{this.getTablePartition(), this.buildOutputPath(), e});
        }
        finally {
            if (this.fileWriter != null) {
                this.fileWriter.attemptCloseResource();
                this.fileWriter.attemptDeleteEmptyFile();
            }
            if (this.asyncFileUploader != null) {
                this.asyncFileUploader.close();
            }
            this.updateTaskDetail();
            super.updateCheckpoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long executeSync(Connection conn, List<String> querySqlList) throws Exception {
        AtomicLong totalSize;
        AtomicLong atomicLong = totalSize = (AtomicLong)this.limitDumpMap.get(this.getTablePartition());
        synchronized (atomicLong) {
            if (this.maxFileSize > 0L && totalSize.get() >= this.maxFileSize) {
                return 0L;
            }
            return this.executeUnsync(conn, querySqlList);
        }
    }

    protected long executeUnsync(Connection conn, List<String> querySqlList) throws Exception {
        boolean hasLocalFileLeft;
        boolean isHeaderPrepended = false;
        long totalCount = 0L;
        long splitSize = 0L;
        AtomicLong totalSize = (AtomicLong)this.limitDumpMap.get(this.getTablePartition());
        boolean hasValues = !this.customQuery && this.tableRangeInfo.hasPrimary();
        block14: for (int i = 0; this.supervisor.get() && i < querySqlList.size(); ++i) {
            long begin = 0L;
            long fetch = 0L;
            long write = 0L;
            if (JvmArgs.isDebugable) {
                begin = System.currentTimeMillis();
            }
            String querySql = querySqlList.get(i);
            RangeKey[] primaryValues = this.tableRangeInfo.getPrimaryValues(i);
            try {
                PreparedStatement ps = this.cachedStreamPreparedStatement(conn, querySql);
                for (int idx = 0; idx < primaryValues.length; ++idx) {
                    ps.setObject(idx + 1, primaryValues[idx].getValue());
                }
                try (ResultSet rs = ps.executeQuery();){
                    if (JvmArgs.isDebugable) {
                        String range = Arrays.stream(primaryValues).map(RangeKey::getValue).collect(Collectors.joining(","));
                        log.info("Query SQL: {}. Range: [{}]. Elapsed: {}ms", new Object[]{querySql, range, System.currentTimeMillis() - begin});
                    }
                    boolean customQueryResetFlag = false;
                    long ftemp = 0L;
                    if (JvmArgs.isDebugable) {
                        ftemp = System.currentTimeMillis();
                    }
                    while (this.supervisor.get() && rs.next()) {
                        if (JvmArgs.isDebugable) {
                            fetch += System.currentTimeMillis() - ftemp;
                        }
                        if (this.customQuery && !customQueryResetFlag) {
                            this.resetRecordTranslator(rs);
                            customQueryResetFlag = true;
                        }
                        if (!isHeaderPrepended) {
                            AbstractRollingFileWriter abstractRollingFileWriter = this.fileWriter = Objects.isNull(this.fileWriter) ? this.createRollingFileWriter().current() : this.fileWriter;
                            if (this.needFileHeader) {
                                this.fileWriter.write(this.recordTranslator.createHeader(this.customQuery, rs));
                                isHeaderPrepended = true;
                            }
                        }
                        Object record = this.recordTranslator.translate(rs, this.customQuery);
                        if (this.recordTranslator instanceof SqlRecordTranslator && ++totalCount > 0L && totalCount % (long)this.commitSize == 0L) {
                            ((SqlRecordTranslator)this.recordTranslator).appendCommitPoint((StringBuilder)record);
                        }
                        long wtemp = 0L;
                        if (JvmArgs.isDebugable) {
                            wtemp = System.currentTimeMillis();
                        }
                        long size = this.fileWriter.write(record);
                        if (JvmArgs.isDebugable) {
                            write += System.currentTimeMillis() - wtemp;
                        }
                        if (this.blockSize > 0L || this.maxFileSize > 0L) {
                            splitSize += "MB".equals(this.blockSizeUnit) ? size : 1L;
                            totalSize.addAndGet(size);
                        }
                        this.meter.mark(1L, size, 1L);
                        if (this.maxFileSize > 0L && totalSize.get() >= this.maxFileSize && totalCount > 0L) {
                            log.warn("Stop dump: {} Size: {} >= {}", new Object[]{this.getTablePartition(), totalSize, this.maxFileSize});
                            break block14;
                        }
                        if (this.blockSize > 0L && splitSize >= this.blockSize) {
                            log.info("Split {} to \"{}\" finished", (Object)this.fileWriter.getFileName(), (Object)this.fileWriter.getActiveFile());
                            String curFile = this.fileWriter.getActiveFile();
                            this.fileWriter = this.fileWriter.rollover();
                            this.uploadIfNeeded(curFile);
                            splitSize = 0L;
                            isHeaderPrepended = false;
                        }
                        if (!JvmArgs.isDebugable) continue;
                        ftemp = System.currentTimeMillis();
                    }
                    if (totalCount == 0L && this.retainEmptyFile) {
                        this.createEmptyFile(this.fileSuffix);
                    }
                }
                if (!JvmArgs.isDebugable) continue;
                log.info("Rs.next total elapsed: {} ms. Write file: \"{}\" total elapsed: {} ms", new Object[]{fetch, this.fileWriter.getActiveFile(), write});
                continue;
            }
            catch (Throwable e) {
                String range = hasValues ? Arrays.stream(primaryValues).map(RangeKey::getValue).collect(Collectors.joining(",")) : "[--]";
                log.error("Dump failed. Reason: {}. SQL: {}. Range: {}.", new Object[]{ExceptionUtils.getRootCauseMessage(e), querySql, range});
                throw new IllegalStateException(e);
            }
        }
        boolean bl = hasLocalFileLeft = this.blockSize <= 0L || splitSize > 0L;
        if (hasLocalFileLeft && !Objects.isNull(this.fileWriter)) {
            this.fileWriter.attemptCloseResource();
            this.uploadIfNeeded(this.fileWriter.getActiveFile());
        }
        return totalCount;
    }

    private AbstractRecordTranslator createRecordTranslator(DumpParameter parameter) {
        AbstractRecordTranslator recordTranslator;
        TableInfo tableInfo = parameter.getDatabase().getTableInfo(this.objectName);
        ControlManager controlManager = parameter.getControlManager();
        if (DataFormat.SQL == parameter.getDataFormat()) {
            recordTranslator = new SqlRecordTranslator(tableInfo, controlManager);
        } else if (DataFormat.CSV == parameter.getDataFormat()) {
            recordTranslator = new CsvRecordTranslator(tableInfo, controlManager, this.csvFormat);
        } else if (DataFormat.CUT == parameter.getDataFormat()) {
            boolean removeNewline = parameter.isRemoveNewline();
            String splitter = parameter.getColumnSplitter();
            recordTranslator = new CutRecordTranslator(tableInfo, controlManager, this.csvFormat, splitter, removeNewline);
        } else if (DataFormat.ORC == parameter.getDataFormat() || DataFormat.PAR == parameter.getDataFormat()) {
            recordTranslator = new ColRecordTranslator(tableInfo, controlManager);
        } else {
            throw new UnsupportedOperationException("Unsupported data format: " + (Object)((Object)parameter.getDataFormat()));
        }
        recordTranslator.setUseRuntimeTableName(parameter.isUseRuntimeTableName());
        return recordTranslator;
    }

    private void resetRecordTranslator(ResultSet rs) throws SQLException {
        ControlManager controlManager;
        boolean useRuntimeName = this.recordTranslator.isUseRuntimeTableName();
        TableInfo tableInfo = this.recordTranslator.getTableInfo();
        tableInfo.resetTableInfo(rs, this.serverMode, useRuntimeName, this.preserveZeroDatetime);
        if (this.recordTranslator instanceof SqlRecordTranslator) {
            ((SqlRecordTranslator)this.recordTranslator).setInsertPrefix(tableInfo.getInsertPrefix().toString() + " VALUES (");
        }
        if (Objects.isNull(controlManager = this.recordTranslator.getControlManager())) {
            return;
        }
        String schemaName = tableInfo.getSchema();
        String tableName = tableInfo.getTable();
        for (ColumnInfo columnInfo : tableInfo.getColumnInfoList()) {
            List<SqlFunction> callStacks;
            ControlDescription control;
            String columnName = columnInfo.getColumnName();
            if (useRuntimeName) {
                schemaName = columnInfo.getSchemaName();
                tableName = columnInfo.getTableName();
            }
            if (Objects.isNull(control = controlManager.getControl(schemaName, tableName, columnName)) || CollectionUtils.isEmpty(callStacks = control.getCallStacks())) continue;
            for (SqlFunction sqlFunction : callStacks) {
                if (!(sqlFunction instanceof AbstractUserDefinedFunction)) continue;
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("column_name", columnName);
                paramMap.put("table_name", tableName);
                paramMap.put("data_type", tableInfo.getColumnType(columnName));
                ((AbstractUserDefinedFunction)sqlFunction).setParams(paramMap);
            }
        }
    }

    @Override
    public String buildOutputPath() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.objectName);
        if (Integer.MAX_VALUE != this.groupNo) {
            sb.append(".").append(this.groupNo);
            sb.append(".*").append(this.fileWriter.getFileSuffix());
        }
        return FileUtils.toPath(this.fileWriter.getFilePath(), sb.toString());
    }

    public void expireCache() {
        if (this.pstmtCache != null) {
            this.pstmtCache.invalidateAll();
        }
        if (this.assembler != null) {
            this.assembler.expireCache();
        }
    }

    @Override
    protected void updateTaskDetail() {
        this.taskDetail.setSchema(this.schemaName);
        this.taskDetail.setObject(this.objectName);
        this.taskDetail.setType(ObjectType.TABLE.getName());
        this.taskDetail.setCount(this.recordCount);
        this.taskDetail.setState(this.taskState);
        this.taskDetail.setError(this.message);
        this.taskDetail.setTaskType(TaskType.DUMP_RECORD);
    }

    protected AbstractRollingFileWriter createRollingFileWriter() throws Exception {
        DumpParameter parameter = this.assembler.getParameter();
        String database = this.connectionKey.getDatabase();
        String filePath = FileUtils.toPath(this.dataPath, database, ObjectType.TABLE.getName());
        String fileName = DBUtils.extractObjectName(this.objectName, null);
        String fileSuffix = parameter.getFileSuffix();
        String initFile = String.join((CharSequence)".", fileName, "" + this.groupNo, "0") + fileSuffix;
        DataFormat format = parameter.getDataFormat();
        Map<String, Object> colMap = parameter.getDatabase().getTableInfo(this.objectName).getColumnTypeMap();
        AbstractRollingFileWriter rfw = FileWriterFactory.createWriter(format, this.groupNo, filePath, fileName, fileSuffix, this.fileEncoding, initFile, database, colMap);
        rfw.setRollable(!format.isColumnOrientedFormat() && parameter.isSplitable());
        rfw.setIdenticalNoMap(this.identicalNoMap);
        rfw.setRetainEmptyFiles(parameter.isRetainEmptyFiles());
        return rfw;
    }

    private void createEmptyFile(String fileSuffix) {
        String fileName;
        String initFile;
        String database = this.connectionKey.getDatabase();
        String filePath = FileUtils.toPath(this.dataPath, database, ObjectType.TABLE.getName());
        String activeFilePath = FileUtils.toPath(filePath, initFile = String.join((CharSequence)".", fileName = DBUtils.extractObjectName(this.objectName, null), "" + this.groupNo, "0") + fileSuffix);
        if (new File(activeFilePath).exists()) {
            String[] extensions = new String[]{fileSuffix.startsWith(".") ? fileSuffix.substring(1) : fileSuffix};
            for (String existsFileName : FileUtils.listFileNames(new File(filePath), extensions)) {
                if (existsFileName.equals(initFile) || !existsFileName.equalsIgnoreCase(initFile)) continue;
                AtomicLong identicalNo = this.identicalNoMap.computeIfAbsent(existsFileName, v -> new AtomicLong(0L));
                StringBuilder sb = new StringBuilder(64);
                sb.append(fileName).append("_ob_identical_").append(identicalNo.incrementAndGet());
                if (Integer.MAX_VALUE != this.groupNo) {
                    sb.append(".").append(this.groupNo);
                    sb.append(".").append("0");
                }
                sb.append(fileSuffix);
                activeFilePath = FileUtils.toPath(filePath, sb.toString());
                break;
            }
        }
        try {
            FileUtils.touch((File)new File(activeFilePath));
            log.debug("Generate an empty file: {} for empty table success.", (Object)activeFilePath);
            this.uploadIfNeeded(activeFilePath);
        }
        catch (Exception e) {
            log.error("Generate an empty file: {} for empty table failed. Reason: {}", (Object)activeFilePath, (Object)ExceptionUtils.getRootCauseMessage(e));
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected SessionOption buildSessionOption() {
        SessionOption opt = super.buildSessionOption();
        if (this.weakRead) {
            opt = SessionOption.join(opt, SessionOption.withProxyRoutePolicy(SessionProperties.getString("ob.proxy.route.policy")));
        }
        if (this.serverMode.isOracleMode()) {
            opt = SessionOption.join(opt, SessionOption.withNlsDateFormat(this.nlsDateFormat), SessionOption.withNlsTimestampFormat(this.nlsTimestampFormat), SessionOption.withNlsTimestampTzFormat(this.nlsTimestampTzFormat));
        }
        return opt;
    }

    protected PreparedStatement cachedStreamPreparedStatement(Connection conn, String sql) throws Exception {
        return (PreparedStatement)this.pstmtCache.get((Object)sql, () -> {
            PreparedStatement pstmt = conn.prepareStatement(sql, 1003, 1007);
            if (this.serverMode.isOracleMode()) {
                pstmt.setFetchSize(this.fetchSize);
            } else {
                pstmt.setFetchSize(Integer.MIN_VALUE);
            }
            return pstmt;
        });
    }

    public void setMeter(Meter meter) {
        this.meter = meter;
    }

    public void setCsvFormat(CsvFormat csvFormat) {
        this.csvFormat = csvFormat;
    }

    public static class FileWriterFactory {
        public static AbstractRollingFileWriter createWriter(DataFormat format, int groupNo, String filePath, String fileName, String fileSuffix, String fileEncoding, String initFile, String database, Map<String, Object> colMap) throws Exception {
            if (format.equals((Object)DataFormat.ORC)) {
                return new OrcFileWriterV2.Builder().withInitFile(FileUtils.toPath(filePath, initFile)).withGroupNo(groupNo).withFilePath(filePath).withFileName(fileName).withFileSuffix(fileSuffix).withColumnTypeMap(colMap).build();
            }
            if (format.equals((Object)DataFormat.PAR)) {
                return new ParquetFileWriterV2.Builder().withInitFile(FileUtils.toPath(filePath, initFile)).withGroupNo(groupNo).withFilePath(filePath).withFileName(fileName).withFileSuffix(fileSuffix).withColumnTypeMap(database, colMap).build();
            }
            return new DefaultFileWriter(groupNo, filePath, fileName, fileSuffix, fileEncoding);
        }
    }
}

