/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.task.schema;

import com.oceanbase.tools.loaddump.common.enums.DbType;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.concurrent.ExecutorTemplate;
import com.oceanbase.tools.loaddump.configure.Configure;
import com.oceanbase.tools.loaddump.dumper.task.schema.ObMysqlSchemaDumpTask;
import com.oceanbase.tools.loaddump.jdbc.JdbcTemplate;
import com.oceanbase.tools.loaddump.schema.model.CreateObjectDefine;
import com.oceanbase.tools.loaddump.schema.model.ObjectDefine;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObMysqlNoSysSchemaDumpTask
extends ObMysqlSchemaDumpTask {
    private static final Logger log = LoggerFactory.getLogger(ObMysqlNoSysSchemaDumpTask.class);
    private static final long serialVersionUID = 5293529517511538794L;

    @Override
    public List<ObjectDefine> dumpSchema(Configure configure) throws Exception {
        if (this.objectType.equalsIgnoreCase(ObjectType.TABLE.getName()) || this.objectType.equals(ObjectType.TABLE_GROUP.getName())) {
            return this.showCreateTableOrTableGroup(configure);
        }
        return super.dumpSchema(configure);
    }

    private List<ObjectDefine> showCreateTableOrTableGroup(Configure configure) {
        JdbcTemplate jdbc = new JdbcTemplate(configure.getSessionManager());
        DbType dbType = DbType.valueOf(this.serverMode.name(), this.serverMode.getVersion());
        ExecutorTemplate<ObjectDefine> template = new ExecutorTemplate<ObjectDefine>("show-create-table-");
        for (Map.Entry entry : this.whiteListMap.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))) continue;
            ObjectType objectType = (ObjectType)((Object)entry.getKey());
            for (String objectName : (Set)entry.getValue()) {
                template.submit(() -> {
                    String tableGrammar = this.queryTableGrammar(jdbc, objectType.getName(), objectName);
                    return new CreateObjectDefine(objectType, objectName, tableGrammar);
                });
            }
        }
        log.info("Query {} schema success. DbType: {} Version: {}", new Object[]{this.objectType, dbType.getType(), dbType.getRealVersion()});
        return template.waitForResult();
    }

    private String queryTableGrammar(JdbcTemplate jdbc, String objectType, String objectName) throws SQLException {
        String sql = "show create " + objectType + " `" + objectName + "`";
        return jdbc.query(sql, null, rs -> rs.next() ? rs.getString(2) + ";" : "");
    }
}

