/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.task.schema;

import com.oceanbase.tools.loaddump.configure.Configure;
import com.oceanbase.tools.loaddump.dumper.task.schema.AbstractSchemaDumpTask;
import com.oceanbase.tools.loaddump.schema.builder.DefaultDatabaseBuilderImpl;
import com.oceanbase.tools.loaddump.schema.model.ObjectDefine;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleDatabase;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.JacksonUtils;
import com.oceanbase.tools.loaddump.vmoption.JvmArgs;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObOracleSchemaDumpTask
extends AbstractSchemaDumpTask {
    private static final Logger log = LoggerFactory.getLogger(ObOracleSchemaDumpTask.class);
    private static final long serialVersionUID = -7805047148834341264L;

    @Override
    public List<ObjectDefine> dumpSchema(Configure configure) throws Exception {
        ObOracleDatabase database = (ObOracleDatabase)new DefaultDatabaseBuilderImpl().build(configure);
        if (JvmArgs.isBackupRestoreMode) {
            String dirPath = this.dataPath.substring(0, this.dataPath.lastIndexOf("data") - 1);
            String schemaFilePath = FileUtils.toPath(dirPath, "database.json");
            FileUtils.write((File)new File(schemaFilePath), (CharSequence)JacksonUtils.toJsonString(database), (String)this.fileEncoding, (boolean)false);
            if (this.asyncFileUploader != null) {
                this.asyncFileUploader.submitUpload(new File(schemaFilePath));
                schemaFilePath = this.asyncFileUploader.getDestUri();
            }
            log.info("Serialize database.json finished. Schema: \"{}\". File: \"{}\"", (Object)database.getSchemaName(), (Object)schemaFilePath);
        }
        return database.buildDefinition();
    }
}

