/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.translator;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.model.MapObject;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.dumper.translator.IRecordTranslator;
import com.oceanbase.tools.loaddump.manager.ControlManager;
import com.oceanbase.tools.loaddump.mybatis.type.TypeHandler;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractRecordTranslator<T>
implements IRecordTranslator<T> {
    protected TableInfo tableInfo;
    protected ControlManager controlManager;
    private boolean useRuntimeTableName = false;

    protected String doCleaning(String schemaName, String table, String columnName, String columnValue) throws Exception {
        if (this.controlManager == null || !this.controlManager.isControlDefined(schemaName, table)) {
            return columnValue;
        }
        Map<String, MapObject> columnIndexMapping = this.tableInfo.getColumnIndexMapping();
        MapObject mapObj = columnIndexMapping.get(columnName);
        if (mapObj.getGeneratedDefine() != null) {
            return mapObj.getGeneratedDefine().getValue();
        }
        return this.controlManager.transform(schemaName, table, columnName, columnValue);
    }

    public CharSequence createHeader(boolean customQuery, ResultSet rs) throws Exception {
        throw new UnsupportedOperationException("No need to create file header for this data format.");
    }

    @Override
    public T translate(ResultSet rs, boolean isNullable) throws Exception {
        int index = 1;
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String tableName = this.tableInfo.getTable();
        String schemaName = this.tableInfo.getSchema();
        Iterator<Integer> iter = isNullable ? Stream.iterate(0, e -> e + 1).limit(columnCount).collect(Collectors.toList()).iterator() : this.getTableInfo().getLogicOffsets().iterator();
        T recordPattern = this.buildRecordPattern(columnCount);
        while (index <= columnCount) {
            TypeHandler<?> typeHandler;
            String columnName = rsmd.getColumnLabel(index);
            Integer i = iter.next();
            if (this.useRuntimeTableName) {
                tableName = rsmd.getTableName(index);
                schemaName = rsmd.getCatalogName(index);
            }
            if ((typeHandler = this.tableInfo.getTypeHandler(columnName)) == null) {
                columnName = rsmd.getColumnName(index);
                typeHandler = this.tableInfo.getTypeHandler(columnName);
                Preconditions.checkArgument((typeHandler != null ? 1 : 0) != 0, (String)"No appropriate type handler was found. Column: %s", (Object)columnName);
            }
            Object result = isNullable ? typeHandler.getNullableResult(rs, index++) : typeHandler.getResult(rs, index++);
            String columnValue = result == null ? null : result.toString();
            columnValue = this.doCleaning(schemaName, tableName, columnName, columnValue);
            this.formatRecord(recordPattern, columnValue, i, iter.hasNext());
        }
        return this.appendLineSeparator(recordPattern);
    }

    protected abstract T buildRecordPattern(int var1);

    protected abstract T formatRecord(T var1, String var2, int var3, boolean var4);

    protected abstract T appendLineSeparator(T var1);

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public ControlManager getControlManager() {
        return this.controlManager;
    }

    public void setControlManager(ControlManager controlManager) {
        this.controlManager = controlManager;
    }

    public boolean isUseRuntimeTableName() {
        return this.useRuntimeTableName;
    }

    public void setUseRuntimeTableName(boolean useRuntimeTableName) {
        this.useRuntimeTableName = useRuntimeTableName;
    }
}

