/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.translator;

import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.dumper.translator.AbstractRecordTranslator;
import com.oceanbase.tools.loaddump.manager.ControlManager;
import com.oceanbase.tools.loaddump.parser.record.csv.CsvFormat;
import com.oceanbase.tools.loaddump.parser.record.csv.CsvPrinter;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.sql.ResultSet;

public class CsvRecordTranslator
extends AbstractRecordTranslator<StringBuilder> {
    private CsvFormat csvFormat;

    public CsvRecordTranslator(TableInfo tableInfo, ControlManager controlManager, CsvFormat csvFormat) {
        this.tableInfo = tableInfo;
        this.controlManager = controlManager;
        this.csvFormat = csvFormat;
    }

    @Override
    public CharSequence createHeader(boolean customQuery, ResultSet rs) throws Exception {
        if (this.csvFormat.getSkipHeaderRecord()) {
            return "";
        }
        if (customQuery) {
            this.csvFormat = this.csvFormat.withHeader(rs);
        }
        StringBuilder sb = new StringBuilder(48);
        try (CsvPrinter printer = new CsvPrinter(sb, this.csvFormat);){
            StringBuilder stringBuilder = sb;
            return stringBuilder;
        }
    }

    @Override
    protected StringBuilder buildRecordPattern(int columnCount) {
        return new StringBuilder(4096);
    }

    @Override
    protected StringBuilder formatRecord(StringBuilder recordPattern, String columnValue, int index, boolean hasNext) {
        if (columnValue == null) {
            recordPattern.append(this.csvFormat.getNullString());
        } else if (StringUtils.isEmpty(columnValue)) {
            recordPattern.append(this.csvFormat.getEmptyString());
        } else {
            boolean isNeedEscape;
            if (this.csvFormat.getTrim()) {
                columnValue = columnValue.trim();
            }
            if (isNeedEscape = this.tableInfo.isNeedEscape(index)) {
                columnValue = this.escapeString(columnValue, this.csvFormat);
            }
            if (isNeedEscape || this.tableInfo.isNeedQuote(index)) {
                Character quoteCharacter = this.csvFormat.getQuoteCharacter();
                recordPattern.append(quoteCharacter).append(columnValue).append(quoteCharacter);
            } else {
                recordPattern.append(columnValue);
            }
        }
        if (hasNext) {
            recordPattern.append(this.csvFormat.getDelimiter());
        }
        return recordPattern;
    }

    @Override
    protected StringBuilder appendLineSeparator(StringBuilder record) {
        return record.append(this.csvFormat.getRecordSeparator());
    }

    public String escapeString(String columnValue, CsvFormat csvFormat) {
        int length = columnValue.length();
        Character quote = csvFormat.getQuoteCharacter();
        Character escape = csvFormat.getEscapeCharacter();
        StringBuilder sb = new StringBuilder(length);
        block5: for (int i = 0; i < length; ++i) {
            char c = columnValue.charAt(i);
            if (c == quote.charValue() || c == escape.charValue()) {
                sb.append(escape).append(c);
                continue;
            }
            switch (c) {
                case '\r': {
                    sb.append(escape).append("\r");
                    continue block5;
                }
                case '\n': {
                    sb.append(escape).append("\n");
                    continue block5;
                }
                case '\t': {
                    sb.append(escape).append("\t");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

