/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.translator;

import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.dumper.translator.AbstractRecordTranslator;
import com.oceanbase.tools.loaddump.manager.ControlManager;
import com.oceanbase.tools.loaddump.utils.SqlUtils;
import java.util.HashMap;
import java.util.Map;

public class SqlRecordTranslator
extends AbstractRecordTranslator<StringBuilder> {
    private String insertPrefix;
    private Map<String, TimeFunctionFormat> functionMap = new HashMap<String, TimeFunctionFormat>();

    public SqlRecordTranslator(TableInfo tableInfo, ControlManager controlManager) {
        this.functionMap.put("date", TimeFunctionFormat.DATE);
        this.functionMap.put("timestamp", TimeFunctionFormat.TIMESTAMP);
        this.functionMap.put("timestamp with time zone", TimeFunctionFormat.TIMESTAMPTZ);
        this.functionMap.put("timestamp with local time zone", TimeFunctionFormat.TIMESTAMPLTZ);
        this.tableInfo = tableInfo;
        this.controlManager = controlManager;
        if (tableInfo.getInsertPrefix() != null) {
            this.insertPrefix = tableInfo.getInsertPrefix() + " VALUES (";
        }
    }

    @Override
    protected StringBuilder buildRecordPattern(int columnCount) {
        return new StringBuilder(4096).append(this.insertPrefix);
    }

    @Override
    protected StringBuilder formatRecord(StringBuilder recordPattern, String columnValue, int index, boolean hasNext) {
        if (columnValue == null) {
            recordPattern.append("null");
            if (hasNext) {
                recordPattern.append(',');
            }
            return recordPattern;
        }
        String columnType = this.tableInfo.getColumnTypeName(index).toLowerCase();
        boolean isMysqlMode = this.tableInfo.isMySqlMode();
        boolean isTimeType = this.functionMap.containsKey(columnType);
        boolean needAppendParentheses = true;
        if (isMysqlMode) {
            if (SqlUtils.isBinaryType(columnType)) {
                recordPattern.append("unhex(");
            } else {
                needAppendParentheses = false;
            }
        } else if (SqlUtils.isBinaryType(columnType)) {
            recordPattern.append("HEXTORAW(");
        } else if (isTimeType) {
            recordPattern.append(this.functionMap.get(columnType).function);
        } else {
            needAppendParentheses = false;
        }
        boolean isNeedEscape = this.tableInfo.isNeedEscape(index);
        if (isNeedEscape) {
            columnValue = this.escapeString(columnValue, this.tableInfo.isMySqlMode());
        }
        if (isNeedEscape || this.tableInfo.isNeedQuote(index)) {
            recordPattern.append("'").append(columnValue).append("'");
            if (!isMysqlMode && isTimeType) {
                recordPattern.append(",").append("'").append(this.functionMap.get(columnType).format).append("'");
            }
        } else {
            recordPattern.append(columnValue);
        }
        if (needAppendParentheses) {
            recordPattern.append(")");
        }
        if (hasNext) {
            recordPattern.append(',');
        }
        return recordPattern;
    }

    @Override
    protected StringBuilder appendLineSeparator(StringBuilder record) {
        return record.append(");").append(System.lineSeparator());
    }

    public StringBuilder appendCommitPoint(StringBuilder record) {
        return record.append("commit;").append(System.lineSeparator());
    }

    public String escapeString(String columnValue, boolean isMySqlMode) {
        int length = columnValue.length();
        StringBuilder sb = new StringBuilder(length);
        block10: for (int i = 0; i < length; ++i) {
            char c = columnValue.charAt(i);
            if (isMySqlMode) {
                switch (c) {
                    case '\r': {
                        sb.append("\\r");
                        break;
                    }
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break;
                    }
                    case '\'': {
                        sb.append("''");
                        break;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        break;
                    }
                    default: {
                        sb.append(c);
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\'': {
                    sb.append("''");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public void setInsertPrefix(String insertPrefix) {
        this.insertPrefix = insertPrefix;
    }

    private static enum TimeFunctionFormat {
        DATE("to_date(", "YYYY-MM-DD HH24:MI:SS"),
        TIMESTAMP("to_timestamp(", "YYYY-MM-DD HH24:MI:SS:FF9"),
        TIMESTAMPTZ("to_timestamp_tz(", "YYYY-MM-DD HH24:MI:SS:FF TZR TZD"),
        TIMESTAMPLTZ("to_timestamp_tz(", "YYYY-MM-DD HH24:MI:SS:FF TZR TZD");

        private final String function;
        private final String format;

        private TimeFunctionFormat(String function, String format) {
            this.function = function;
            this.format = format;
        }
    }
}

