/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.uploader;

import com.oceanbase.tools.loaddump.dumper.uploader.BytesProgressListener;
import com.oceanbase.tools.loaddump.resource.remote.FileUploader;
import com.oceanbase.tools.loaddump.utils.TimeUtils;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchFileUploader
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(BatchFileUploader.class);
    private final FileUploader fileUploader;
    protected static final int SUCCESS_FLAG = 1;
    protected static final int FAILURE_FLAG = 0;

    public BatchFileUploader(FileUploader fileUploader) {
        this.fileUploader = fileUploader;
    }

    public int[] uploadBatch(List<File> files) throws Exception {
        int[] affectResources = new int[files.size()];
        long totalLength = files.stream().mapToLong(com.oceanbase.tools.loaddump.utils.FileUtils::getSize).sum();
        List listeners = Collections.synchronizedList(new ArrayList(files.size()));
        AtomicInteger currentIdx = new AtomicInteger(0);
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            while (currentIdx.get() < files.size()) {
                File file = (File)files.get(currentIdx.get());
                BytesProgressListener listener = new BytesProgressListener();
                listeners.add(listener);
                try {
                    this.fileUploader.upload(file, listener);
                }
                catch (Throwable e) {
                    affectResources[currentIdx.get()] = 0;
                    continue;
                }
                affectResources[currentIdx.get()] = 1;
                currentIdx.getAndIncrement();
            }
        });
        int counter = 0;
        while (!future.isDone()) {
            if (counter % 20 == 0) {
                File currentFile = files.get(currentIdx.get());
                long totalBytesWritten = listeners.stream().mapToLong(l -> l.getBytesWritten().get()).sum();
                String writtenDisplaySize = FileUtils.byteCountToDisplaySize((long)totalBytesWritten);
                String totalDisplaySize = FileUtils.byteCountToDisplaySize((long)totalLength);
                String progress = new DecimalFormat("#0.0").format((double)totalBytesWritten * 100.0 / (double)totalLength) + "%";
                log.info("Upload \"{}\" now. Progress: {} ({}/{}). ", new Object[]{currentFile.getAbsolutePath(), progress, writtenDisplaySize, totalDisplaySize});
            }
            ++counter;
            TimeUtils.sleep(TimeUnit.MILLISECONDS, 500L);
        }
        return affectResources;
    }

    @Override
    public void close() throws Exception {
        this.fileUploader.close();
    }
}

