/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.factory;

import com.oceanbase.tools.loaddump.common.enums.StorageType;
import com.oceanbase.tools.loaddump.common.model.storage.BaseStorageConfig;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.OssStorageConfig;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.S3StorageConfig;
import com.oceanbase.tools.loaddump.resource.remote.FileUploader;
import com.oceanbase.tools.loaddump.resource.remote.oss.OssFileUploader;
import com.oceanbase.tools.loaddump.resource.remote.s3.S3FileUploader;

public class FileUploaderFactory {
    public static FileUploader createFileUploader(BaseStorageConfig storageConfig, String filePath, boolean useCustomPath) {
        if (storageConfig.getStorageType() == StorageType.ALIYUN_OSS) {
            return new OssFileUploader((OssStorageConfig)storageConfig, filePath, useCustomPath);
        }
        if (storageConfig.getStorageType() == StorageType.AMAZON_S3) {
            return new S3FileUploader((S3StorageConfig)storageConfig, filePath, useCustomPath);
        }
        throw new IllegalArgumentException("Unsupported storage: " + (Object)((Object)storageConfig.getStorageType()));
    }

    public static FileUploader createFileUploader(BaseStorageConfig storageConfig, String filePath) {
        return FileUploaderFactory.createFileUploader(storageConfig, filePath, false);
    }
}

