/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.factory;

import com.oceanbase.tools.loaddump.common.model.datatype.ObDate;
import com.oceanbase.tools.loaddump.common.model.datatype.ObDateTime;
import com.oceanbase.tools.loaddump.common.model.datatype.ObTime;
import com.oceanbase.tools.loaddump.common.model.datatype.ObTimestamp;
import com.oceanbase.tools.loaddump.common.model.datatype.ObTimestampLtz;
import com.oceanbase.tools.loaddump.common.model.datatype.ObTimestampTz;
import com.oceanbase.tools.loaddump.mybatis.type.JdbcType;
import com.oceanbase.tools.loaddump.mybatis.type.TypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.TypeHandlerRegistry;
import com.oceanbase.tools.loaddump.mybatis.type.YearTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.custom.BinaryToHexStringTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.custom.DateTimeToStringTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.custom.DateToStringTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.custom.TimeToStringTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.custom.TimestampToStringTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.custom.TimestampWithLocalTimeZoneToStringHandler;
import com.oceanbase.tools.loaddump.mybatis.type.custom.TimestampWithTimeZoneToStringTypeHandler;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Locale;
import lombok.NonNull;

public class TypeHandlerFactory {
    public static TypeHandler<?> createTypeHandler(@NonNull Object dataTypeObj, boolean isMySqlMode, boolean preserveZeroDatetime) {
        if (dataTypeObj == null) {
            throw new NullPointerException("dataTypeObj is marked non-null but is null");
        }
        if (dataTypeObj instanceof ObDate) {
            return new DateToStringTypeHandler(((ObDate)dataTypeObj).getPattern(), isMySqlMode, preserveZeroDatetime);
        }
        if (dataTypeObj instanceof ObDateTime) {
            String pattern = ((ObDateTime)dataTypeObj).getPattern();
            int precision = ((ObDateTime)dataTypeObj).getPrecision();
            return new DateTimeToStringTypeHandler(pattern, precision, preserveZeroDatetime);
        }
        if (dataTypeObj instanceof ObTime) {
            String pattern = ((ObTime)dataTypeObj).getPattern();
            int precision = ((ObTime)dataTypeObj).getPrecision();
            return new TimeToStringTypeHandler(pattern, precision, preserveZeroDatetime);
        }
        if (dataTypeObj instanceof ObTimestamp) {
            String pattern = ((ObTimestamp)dataTypeObj).getPattern();
            int precision = ((ObTimestamp)dataTypeObj).getPrecision();
            return new TimestampToStringTypeHandler(isMySqlMode, pattern, precision, preserveZeroDatetime);
        }
        if (dataTypeObj instanceof ObTimestampTz) {
            String pattern = ((ObTimestampTz)dataTypeObj).getPattern();
            int precision = ((ObTimestampTz)dataTypeObj).getPrecision();
            return new TimestampWithTimeZoneToStringTypeHandler(pattern, precision);
        }
        if (dataTypeObj instanceof ObTimestampLtz) {
            String pattern = ((ObTimestampLtz)dataTypeObj).getPattern();
            int precision = ((ObTimestampLtz)dataTypeObj).getPrecision();
            return new TimestampWithLocalTimeZoneToStringHandler(pattern, precision);
        }
        String dataType = dataTypeObj.toString();
        dataType = dataType.trim().toLowerCase(Locale.getDefault());
        TypeHandlerRegistry typeHandlerRegistry = TypeHandlerRegistry.getInstance();
        if (isMySqlMode) {
            int index = dataType.indexOf("unsigned");
            dataType = index > -1 ? dataType.substring(0, index).trim() : dataType;
        }
        switch (dataType) {
            case "bool": 
            case "boolean": 
            case "int": 
            case "integer": 
            case "tinyint": 
            case "smallint": {
                if (isMySqlMode) {
                    return typeHandlerRegistry.getTypeHandler(JdbcType.BIGINT);
                }
                return typeHandlerRegistry.getTypeHandler(JdbcType.INTEGER);
            }
            case "double": {
                return typeHandlerRegistry.getTypeHandler(JdbcType.DOUBLE);
            }
            case "number": {
                if (isMySqlMode) {
                    return typeHandlerRegistry.getTypeHandler(JdbcType.DECIMAL);
                }
                return typeHandlerRegistry.getTypeHandler(JdbcType.CHAR);
            }
            case "numeric": 
            case "real": 
            case "decimal": 
            case "bigint": 
            case "bigdecimal": 
            case "binary_float": 
            case "binary_double": {
                return typeHandlerRegistry.getTypeHandler(JdbcType.DECIMAL);
            }
            case "float": 
            case "char": 
            case "varchar": 
            case "varchar2": 
            case "longvarchar": 
            case "tinytext": 
            case "text": 
            case "mediumtext": 
            case "longtext": 
            case "set": 
            case "enum": 
            case "intervalym": 
            case "interval year to month": 
            case "interval year to second": 
            case "timestamp with time zone": {
                return typeHandlerRegistry.getTypeHandler(JdbcType.CHAR);
            }
            case "time": {
                return typeHandlerRegistry.getTypeHandler(Time.class);
            }
            case "timestamp": 
            case "timestamp with local time zone": {
                return typeHandlerRegistry.getTypeHandler(Timestamp.class);
            }
            case "date": {
                return new DateToStringTypeHandler(isMySqlMode);
            }
            case "datetime": {
                return new DateTimeToStringTypeHandler();
            }
            case "year": {
                return new YearTypeHandler(preserveZeroDatetime);
            }
            case "bit": 
            case "raw": 
            case "longraw": 
            case "binary": 
            case "varbinary": 
            case "longvarbinary": 
            case "tinyblob": 
            case "blob": 
            case "mediumblob": 
            case "longblob": {
                return new BinaryToHexStringTypeHandler();
            }
            case "clob": {
                return typeHandlerRegistry.getTypeHandler(JdbcType.CLOB);
            }
            case "nclob": {
                return typeHandlerRegistry.getTypeHandler(JdbcType.NCLOB);
            }
            case "cursor": {
                return typeHandlerRegistry.getTypeHandler(JdbcType.CURSOR);
            }
            case "nchar": 
            case "nvarchar": 
            case "nchar2": 
            case "nvarchar2": 
            case "longnvarchar": {
                return typeHandlerRegistry.getTypeHandler(JdbcType.NVARCHAR);
            }
        }
        return typeHandlerRegistry.getTypeHandler(JdbcType.OTHER);
    }
}

