/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.function.number;

import com.oceanbase.tools.loaddump.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.function.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.utils.NumberUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;

public class NanvlFunction
extends AbstractBuiltinFunction {
    private String replacement = "0";

    public NanvlFunction() {
    }

    public NanvlFunction(String replacement) {
        this.replacement = replacement;
    }

    @Override
    public String getName() {
        return SqlFunctions.NANVL.name();
    }

    @Override
    public String invoke(String ... varargs) {
        return this.nanvl(varargs == null ? null : varargs[0]);
    }

    private String nanvl(String value) {
        if (StringUtils.isBlank(value)) {
            return this.replacement;
        }
        try {
            value = value.trim();
            NumberUtils.toScaledBigDecimal(value);
            return value;
        }
        catch (Exception e) {
            return this.replacement;
        }
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }
}

