/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.function.string;

import com.oceanbase.tools.loaddump.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.function.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class HexToRawFunction
extends AbstractBuiltinFunction {
    private static final HexToRawFunction SINGLETON = new HexToRawFunction();

    private HexToRawFunction() {
    }

    public static HexToRawFunction newInstance() {
        return SINGLETON;
    }

    @Override
    public String getName() {
        return SqlFunctions.HEX_TO_RAW.name();
    }

    @Override
    public String invoke(String ... varargs) {
        if (varargs[0] == null) {
            return null;
        }
        try {
            byte[] arr = Hex.decodeHex((char[])varargs[0].toCharArray());
            return new String(arr, StandardCharsets.UTF_8);
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("Invalid hexadecimal string: " + StringUtils.abbreviate((String)varargs[0], (int)100) + ". Error: " + e.getMessage());
        }
    }
}

