/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.manager;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.function.context.ControlContext;
import com.oceanbase.tools.loaddump.function.context.ControlDescription;
import com.oceanbase.tools.loaddump.parser.record.pos.Offset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ControlManager {
    private static final Logger log = LoggerFactory.getLogger(ControlManager.class);
    private final Map<String, Map<String, ControlContext>> schemaControlContextMap = new HashMap<String, Map<String, ControlContext>>();

    private ControlManager() {
    }

    public static ControlManager newInstance() {
        return new ControlManager();
    }

    public synchronized void register(String schemaName, String tableName, ControlContext controlContext) {
        this.schemaControlContextMap.computeIfAbsent(schemaName, v -> new HashMap()).put(tableName, controlContext);
    }

    public ControlDescription getControl(String schemaName, String tableName, String columnName) {
        Map<String, ControlContext> map = this.schemaControlContextMap.get(schemaName);
        if (MapUtils.isEmpty(map) || map.get(tableName) == null) {
            return null;
        }
        return map.get(tableName).getControlDescriptionByColumnName(columnName);
    }

    public boolean isControlDefined(String schemaName, String tableName) {
        Map<String, ControlContext> map = this.schemaControlContextMap.get(schemaName);
        return MapUtils.isNotEmpty(map) && map.get(tableName) != null;
    }

    public List<Offset> getOffsets(String schemaName, String tableName) {
        Map<String, ControlContext> map = this.schemaControlContextMap.get(schemaName);
        Preconditions.checkArgument((MapUtils.isNotEmpty(map) && map.get(tableName) != null ? 1 : 0) != 0, (String)"The control context is null. Table: %s", (Object)tableName);
        return map.get(tableName).getOffsets();
    }

    public String transform(String schemaName, String tableName, String columnName, String value) throws Exception {
        ControlDescription description;
        if (this.isControlDefined(schemaName, tableName) && (description = this.getControl(schemaName, tableName, columnName)) != null) {
            return description.invoke(value);
        }
        return value;
    }
}

