/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.manager;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.exception.ConnectFailedException;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.jdbc.JdbcExecutor;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import com.oceanbase.tools.loaddump.vmoption.JvmArgs;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceManager {
    private static final Logger log = LoggerFactory.getLogger(DataSourceManager.class);
    private boolean supportSys;
    private ConnectionKey connectionKey;
    private Map<DataSourceType, DruidDataSource> dataSourceCache;
    static final String GET_VERSION_OB_COMP_MODE_SQL = "show variables where Variable_name in ('version_comment','ob_compatibility_mode')";

    public DataSourceManager(ConnectionKey connectionKey) throws Exception {
        this.connectionKey = connectionKey;
        this.dataSourceCache = new ConcurrentHashMap<DataSourceType, DruidDataSource>(2);
        try {
            this.dataSourceCache.put(DataSourceType.BIZ, this.createBusinessDataSource(true));
            try (DruidPooledConnection conn = this.getBusinessDataSource().getConnection();){
                connectionKey.setServerMode(this.queryServerMode((Connection)conn));
            }
            if (connectionKey.getServerMode().isPreviousV4() && !connectionKey.hasNoSysPrivileges()) {
                this.dataSourceCache.put(DataSourceType.SYS, this.createSystemDataSource(true));
                this.supportSys = true;
            }
        }
        catch (Exception ex) {
            throw new ConnectFailedException("Init DataSourceManager failed. Error: {}", ExceptionUtils.getRootCauseMessage((Throwable)ex));
        }
    }

    public ServerMode queryServerMode(Connection conn) throws Exception {
        return JdbcExecutor.query(conn, GET_VERSION_OB_COMP_MODE_SQL, rs -> {
            Preconditions.checkState((boolean)rs.first(), (Object)"Query server mode is null");
            rs.beforeFirst();
            ServerMode serverMode = ServerMode.MYSQL;
            while (rs.next()) {
                if (StringUtils.equals("version_comment", rs.getString(1))) {
                    String versionComment = rs.getString(2);
                    serverMode.setVersion(versionComment.split(" ")[1]);
                }
                if (!StringUtils.equals("ob_compatibility_mode", rs.getString(1))) continue;
                serverMode = ServerMode.of(rs.getString(2));
            }
            return serverMode;
        });
    }

    public DruidDataSource getBusinessDataSource() throws Exception {
        DruidDataSource dataSource = this.dataSourceCache.get((Object)DataSourceType.BIZ);
        Preconditions.checkState((dataSource != null ? 1 : 0) != 0, (String)"The xxx@tenant DataSource is null. Key: %s", (Object)this.connectionKey);
        Preconditions.checkState((!dataSource.isClosed() ? 1 : 0) != 0, (String)"The xxx@tenant DataSource is closed. Key: %s", (Object)this.connectionKey);
        Preconditions.checkState((boolean)dataSource.isInited(), (String)"Create xxx@tenant DataSource failed. Key: %s", (Object)this.connectionKey);
        return dataSource;
    }

    public DruidDataSource getSystemDataSource() throws Exception {
        if (this.connectionKey.hasNoSysPrivileges() || !this.connectionKey.getServerMode().isPreviousV4()) {
            String arg = this.connectionKey.hasNoSysPrivileges() ? "--public-cloud" : "observer is " + this.connectionKey.getServerMode().getVersion();
            log.info("No need to acquire DataSource for xxx@sys, as {}", (Object)arg);
            return null;
        }
        DruidDataSource dataSource = this.dataSourceCache.get((Object)DataSourceType.SYS);
        Preconditions.checkState((dataSource != null ? 1 : 0) != 0, (String)"The xxx@sys DataSource is null. Key: %s", (Object)this.connectionKey);
        Preconditions.checkState((boolean)dataSource.isInited(), (String)"Create xxx@sys DataSource failed. Key: %s", (Object)this.connectionKey);
        Preconditions.checkState((!dataSource.isClosed() ? 1 : 0) != 0, (String)"The xxx@sys DataSource is closed. Key: %s", (Object)this.connectionKey);
        return dataSource;
    }

    public synchronized boolean isDestroyed() {
        return MapUtils.isEmpty(this.dataSourceCache);
    }

    public synchronized void destroy() {
        for (DataSourceType key : this.dataSourceCache.keySet()) {
            try {
                DruidDataSource dataSource = this.dataSourceCache.remove((Object)key);
                if (dataSource == null) continue;
                dataSource.close();
                log.info("Close connections: {} of the {} DataSource.", (Object)dataSource.getCloseCount(), (Object)key);
            }
            catch (Exception e) {
                log.warn("Ignore close failed. Message: {}", (Object)e.getMessage());
            }
        }
    }

    public DruidDataSource createBusinessDataSource(boolean isAsync) throws Exception {
        try {
            String url = this.connectionKey.getJdbcUrl(true);
            if (JvmArgs.isDebugable) {
                log.info("JDBC url for business tenant: {}", (Object)url);
            }
            String username = this.connectionKey.getDefaultUser();
            String password = this.connectionKey.getPassword();
            String driverClassName = this.connectionKey.getDriverClassName();
            String connectionProps = this.buildConnectionProps(this.connectionKey);
            return this.createDataSource(url, username, password, connectionProps, driverClassName, isAsync);
        }
        catch (Throwable th) {
            log.error("Create data source for business tenant failed. Reason: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)th));
            throw th;
        }
    }

    public DruidDataSource createSystemDataSource(boolean isAsync) throws Exception {
        try {
            String url = this.connectionKey.getJdbcUrl("oceanbase");
            if (JvmArgs.isDebugable) {
                log.info("JDBC url for sys tenant: {}", (Object)url);
            }
            String username = this.connectionKey.getSysTenantUser();
            String password = this.connectionKey.getSysPassword();
            String driverClassName = this.connectionKey.getDriverClassName();
            String connectProps = this.buildConnectionProps(this.connectionKey);
            return this.createDataSource(url, username, password, connectProps, driverClassName, isAsync);
        }
        catch (Throwable th) {
            log.error("Create data source for sys tenant failed. Reason: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)th));
            throw th;
        }
    }

    DruidDataSource createDataSource(String url, String user, String password, String props, String driverClassName, boolean isAsync) throws Exception {
        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setUrl(url);
        druidDataSource.setInitialSize(this.connectionKey.getMaxPoolSize());
        druidDataSource.setMinIdle(1);
        druidDataSource.setMaxActive(this.connectionKey.getMaxPoolSize());
        druidDataSource.setUsername(user);
        druidDataSource.setPassword(password);
        druidDataSource.setMaxWait(60000L);
        druidDataSource.setFailFast(true);
        druidDataSource.setKeepAlive(true);
        druidDataSource.setAsyncInit(true);
        druidDataSource.setTestOnBorrow(false);
        druidDataSource.setTestOnReturn(false);
        druidDataSource.setMaxCreateTaskCount(8);
        druidDataSource.setTestWhileIdle(true);
        druidDataSource.setConnectionProperties(props);
        druidDataSource.setNotFullTimeoutRetryCount(-1);
        druidDataSource.setBreakAfterAcquireFailure(isAsync);
        druidDataSource.setValidationQuery("select 1 from dual");
        druidDataSource.setDriverClassName(driverClassName);
        druidDataSource.init();
        druidDataSource.setConnectTimeout(this.connectionKey.getConnectTimeout());
        druidDataSource.setSocketTimeout(this.connectionKey.getSocketTimeout());
        return druidDataSource;
    }

    private String buildConnectionProps(ConnectionKey key) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("useSSL=").append(key.isUseSsl());
        sb.append(";socketTimeout=").append(key.getSocketTimeout());
        sb.append(";connectTimeout=").append(key.getConnectTimeout());
        sb.append(";allowMultiQueries=").append(key.isAllowMultiQueries());
        sb.append(";characterEncoding=").append(key.getCharacterEncoding());
        sb.append(";verifyServerCertificate=").append(key.isVerifyServerCertificate());
        sb.append(";zeroDateTimeBehavior=").append(key.getZeroDateTimeBehavior());
        sb.append(";usePipelineAuth=").append(key.isUsePipelineAuth());
        sb.append(";emulateUnsupportedPstmts=").append(key.isEmulateUnsupportedPstmts());
        sb.append(";useServerPrepStmts=").append(key.isUseServerPrepStmts());
        return sb.append(";rewriteBatchedStatements=").append(key.isRewriteBatchedStatements()).toString();
    }

    public DataSourceManager() {
    }

    public boolean isSupportSys() {
        return this.supportSys;
    }

    public ConnectionKey getConnectionKey() {
        return this.connectionKey;
    }

    static enum DataSourceType {
        SYS,
        BIZ;

    }
}

