/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.manager.session;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.base.State;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.exception.ConnectFailedException;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.manager.DataSourceManager;
import com.oceanbase.tools.loaddump.manager.session.SessionOption;
import com.oceanbase.tools.loaddump.manager.session.SessionProperties;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.JdbcUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import com.oceanbase.tools.loaddump.utils.TimeUtils;
import com.oceanbase.tools.loaddump.vmoption.JvmArgs;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager {
    private static final Logger log = LoggerFactory.getLogger(SessionManager.class);
    private State state;
    private DataSourceManager dataSourceManager;
    private final Set<Long> readyBizConnections = new HashSet<Long>();
    private final Set<Long> readySysConnections = new HashSet<Long>();
    private SessionOption initBizSessionVariables;
    private SessionOption initSysSessionVariables;

    public SessionManager init(ConnectionKey connectionKey) throws Exception {
        this.dataSourceManager = new DataSourceManager(connectionKey);
        this.initBizSessionVariables = SessionOption.join(SessionOption.withQueryTimeout(SessionProperties.minToMicros("ob.timeout.for.query.metadata")), SessionOption.withTrxTimeout(SessionProperties.minToMicros("ob.timeout.for.exec.ddl")));
        if (ServerMode.ORACLE.equals((Object)connectionKey.getServerMode())) {
            this.initBizSessionVariables = SessionOption.join(this.initBizSessionVariables, SessionOption.withNlsDateFormat(connectionKey.getNlsDateFormat()), SessionOption.withNlsTimestampFormat(connectionKey.getNlsTimestampFormat()), SessionOption.withNlsTimestampTzFormat(connectionKey.getNlsTimestampTzFormat()));
        }
        this.initSysSessionVariables = SessionOption.join(SessionOption.withQueryTimeout(SessionProperties.minToMicros("ob.timeout.for.query.metadata")), SessionOption.withTrxTimeout(SessionProperties.minToMicros("ob.timeout.for.exec.ddl")));
        this.state = State.INITIAL;
        return this;
    }

    public boolean isSupportSys() {
        return this.dataSourceManager.isSupportSys();
    }

    public ConnectionKey getConnectionKey() {
        return this.dataSourceManager.getConnectionKey();
    }

    public DruidDataSource getSystemDataSource() throws Exception {
        Preconditions.checkState((this.state == State.INITIAL ? 1 : 0) != 0, (Object)"SessionManager is not initialized");
        return this.dataSourceManager.getSystemDataSource();
    }

    public DruidDataSource getBusinessDataSource() throws Exception {
        Preconditions.checkState((this.state == State.INITIAL ? 1 : 0) != 0, (Object)"SessionManager is not initialized");
        return this.dataSourceManager.getBusinessDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getPooledBizConnection() throws Exception {
        Preconditions.checkState((this.state == State.INITIAL ? 1 : 0) != 0, (Object)"SessionManager is not initialized");
        DruidPooledConnection conn = this.dataSourceManager.getBusinessDataSource().getConnection();
        if (this.readyBizConnections.contains(conn.getConnectionHolder().getConnectionId())) {
            return conn;
        }
        JdbcUtils.execute((Connection)conn, SessionOption.join(this.initBizSessionVariables).getStatements());
        Set<Long> set = this.readyBizConnections;
        synchronized (set) {
            this.readyBizConnections.add(conn.getConnectionHolder().getConnectionId());
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getPooledSysConnection() throws Exception {
        Preconditions.checkState((this.state == State.INITIAL ? 1 : 0) != 0, (Object)"SessionManager is not initialized");
        DruidPooledConnection conn = this.dataSourceManager.getSystemDataSource().getConnection();
        if (this.readySysConnections.contains(conn.getConnectionHolder().getConnectionId())) {
            return conn;
        }
        JdbcUtils.execute((Connection)conn, SessionOption.join(this.initSysSessionVariables).getStatements());
        Set<Long> set = this.readySysConnections;
        synchronized (set) {
            this.readySysConnections.add(conn.getConnectionHolder().getConnectionId());
        }
        return conn;
    }

    public Connection createNewConnection(boolean useDatabase, SessionOption ... options) {
        return this.createNewConnection(useDatabase, false, options);
    }

    public Connection createNewConnection(boolean useDatabase, boolean supportBatch, SessionOption ... options) {
        int retryTimes = 0;
        while (true) {
            try {
                ++retryTimes;
                String url = this.getConnectionKey().getJdbcUrl(useDatabase, supportBatch);
                if (JvmArgs.isDebugable) {
                    log.info("Creating new connection. JDBC URL: {}", (Object)url);
                }
                String username = this.getConnectionKey().getDefaultUser();
                String password = this.getConnectionKey().getPassword();
                Connection conn = DriverManager.getConnection(url, username, password);
                String execSql = SessionOption.join(options).getStatements();
                if (StringUtils.isNotBlank(execSql)) {
                    JdbcUtils.execute(conn, execSql);
                }
                return conn;
            }
            catch (Exception ex) {
                boolean shouldRetry;
                String error = ExceptionUtils.getRootCauseMessage(ex);
                boolean bl = shouldRetry = error.contains("Timeout") || error.contains("Connection is closed");
                if (retryTimes < 5 && shouldRetry) {
                    TimeUtils.sleep(TimeUnit.MILLISECONDS, new Random().nextInt(500));
                    log.warn("Retry {} times to get direct connection, ignore it. Cause: {}", (Object)retryTimes, (Object)error);
                    continue;
                }
                throw new ConnectFailedException(ex, "Get direct connection failed. Key: {}", this.getConnectionKey());
            }
            break;
        }
    }

    public void close() {
        this.dataSourceManager.destroy();
        this.state = State.TERMINATE;
    }

    public boolean isClosed() {
        return this.state == State.TERMINATE && this.dataSourceManager.isDestroyed();
    }
}

