/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.manager.session;

import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SessionOption {
    private static final String SET_ENCODING = "set names ";
    private static final String OPEN_AUTOCOMMIT = "set autocommit=1";
    private static final String CLOSE_AUTOCOMMIT = "set autocommit=0";
    private static final String SET_ALLOWED_PACKET = "set global max_allowed_packet=";
    private static final String OPEN_FOREIGN_CHECKS = "SET FOREIGN_KEY_CHECKS=1";
    private static final String CLOSE_FOREIGN_CHECKS = "SET FOREIGN_KEY_CHECKS=0";
    private static final String TRX_TIMEOUT = "set @@session.ob_trx_timeout=";
    private static final String QUERY_TIMEOUT = "set @@session.ob_query_timeout=";
    private static final String NET_READ_TIMEOUT = "set session net_read_timeout=";
    private static final String NET_WRITE_TIMEOUT = "set session net_write_timeout=";
    private static final String PROXY_ROUTE_POLICY = "set @proxy_route_policy= ";
    private static final String SET_OPEN_CURSORS = "alter system set open_cursors=";
    private static final String SET_NLS_DATE_FORMAT = "alter session set nls_date_format=";
    private static final String SET_NLS_TIMESTAMP_FORMAT = "alter session set nls_timestamp_format=";
    private static final String SET_NLS_TZ_TIMESTAMP_FORMAT = "alter session set nls_timestamp_tz_format=";
    private static final String SET_SQL_LIMIT = "set @@session.sql_select_limit=";
    private List<String> statements = new ArrayList<String>();

    private SessionOption(String statement) {
        this.statements.add(statement);
    }

    public static SessionOption withQueryTimeout(long timeout) {
        return new SessionOption(QUERY_TIMEOUT + timeout);
    }

    public static SessionOption withEncoding(String encoding) {
        return new SessionOption(SET_ENCODING + encoding);
    }

    public static SessionOption withOpenAutoCommit() {
        return new SessionOption(OPEN_AUTOCOMMIT);
    }

    public static SessionOption withCloseAutoCommit() {
        return new SessionOption(CLOSE_AUTOCOMMIT);
    }

    public static SessionOption withMaxAllowedPacket(long maxAllowedPacket) {
        return new SessionOption(SET_ALLOWED_PACKET + maxAllowedPacket);
    }

    public static SessionOption withOpenForeignCheck() {
        return new SessionOption(OPEN_FOREIGN_CHECKS);
    }

    public static SessionOption withCloseForeignCheck() {
        return new SessionOption(CLOSE_FOREIGN_CHECKS);
    }

    public static SessionOption withTrxTimeout(long timeout) {
        return new SessionOption(TRX_TIMEOUT + timeout);
    }

    public static SessionOption withNetReadTimeout(long timeout) {
        return new SessionOption(NET_READ_TIMEOUT + timeout);
    }

    public static SessionOption withNetWriteTimeout(long timeout) {
        return new SessionOption(NET_WRITE_TIMEOUT + timeout);
    }

    public static SessionOption withProxyRoutePolicy(String policy) {
        return new SessionOption("set @proxy_route_policy= '" + policy + "'");
    }

    public static SessionOption withMaxOpenCursor(int maxOpenCursor) {
        return new SessionOption(SET_OPEN_CURSORS + maxOpenCursor);
    }

    public static SessionOption withNlsDateFormat(String dateFormat) {
        return new SessionOption("alter session set nls_date_format='" + dateFormat + "'");
    }

    public static SessionOption withNlsTimestampFormat(String timestampFormat) {
        return new SessionOption("alter session set nls_timestamp_format='" + timestampFormat + "'");
    }

    public static SessionOption withNlsTimestampTzFormat(String timestampTzFormat) {
        return new SessionOption("alter session set nls_timestamp_tz_format='" + timestampTzFormat + "'");
    }

    public static SessionOption withSelectLimit(long selectLimit) {
        return new SessionOption(SET_SQL_LIMIT + selectLimit);
    }

    public static SessionOption join(SessionOption ... opts) {
        SessionOption option = new SessionOption();
        if (opts != null && opts.length > 0) {
            option.statements = Arrays.stream(opts).filter(Objects::nonNull).flatMap(o -> o.statements.stream()).collect(Collectors.toList());
        }
        return option;
    }

    public String getStatements() {
        return CollectionUtils.isEmpty(this.statements) ? "" : String.join((CharSequence)";", this.statements) + ";";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionOption option = (SessionOption)o;
        return this.statements.equals(option.statements);
    }

    public int hashCode() {
        return Objects.hash(this.statements);
    }

    public SessionOption() {
    }
}

