/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.manager.session;

import com.alibaba.druid.pool.ha.PropertiesUtils;
import com.google.common.base.Preconditions;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.lang3.math.NumberUtils;

public class SessionProperties {
    private static final String SESSION_PROPERTY_PATH = System.getProperty("session.configurationFile");
    private static final SessionProperties SINGLETON = new SessionProperties();
    private final Properties SESSION_PROPERTIES = new Properties();

    private SessionProperties() {
    }

    public static String getString(@NonNull String variableName) {
        if (variableName == null) {
            throw new NullPointerException("variableName is marked non-null but is null");
        }
        return SessionProperties.SINGLETON.SESSION_PROPERTIES.getProperty(variableName);
    }

    public static void setString(@NonNull String variableName, String value) {
        if (variableName == null) {
            throw new NullPointerException("variableName is marked non-null but is null");
        }
        SessionProperties.SINGLETON.SESSION_PROPERTIES.setProperty(variableName, value);
    }

    private static long getLong(@NonNull String variableName) {
        if (variableName == null) {
            throw new NullPointerException("variableName is marked non-null but is null");
        }
        return Long.parseLong(SessionProperties.SINGLETON.SESSION_PROPERTIES.getProperty(variableName));
    }

    public static boolean getBoolean(@NonNull String variableName) {
        if (variableName == null) {
            throw new NullPointerException("variableName is marked non-null but is null");
        }
        return Boolean.parseBoolean(SessionProperties.SINGLETON.SESSION_PROPERTIES.getProperty(variableName));
    }

    public static long minToMills(@NonNull String variableName) {
        if (variableName == null) {
            throw new NullPointerException("variableName is marked non-null but is null");
        }
        return TimeUnit.MINUTES.toMillis(SessionProperties.getLong(variableName));
    }

    public static long minToMicros(@NonNull String variableName) {
        if (variableName == null) {
            throw new NullPointerException("variableName is marked non-null but is null");
        }
        return TimeUnit.MINUTES.toMicros(SessionProperties.getLong(variableName));
    }

    public static long hourToMicros(@NonNull String variableName) {
        if (variableName == null) {
            throw new NullPointerException("variableName is marked non-null but is null");
        }
        return TimeUnit.HOURS.toMicros(SessionProperties.getLong(variableName));
    }

    public static long hourToSeconds(@NonNull String variableName) {
        if (variableName == null) {
            throw new NullPointerException("variableName is marked non-null but is null");
        }
        return TimeUnit.HOURS.toSeconds(SessionProperties.getLong(variableName));
    }

    private static void validateProperties() {
        try {
            int socketTimeout = Integer.parseInt(SessionProperties.SINGLETON.SESSION_PROPERTIES.getProperty("jdbc.url.socket.timeout", "30"));
            int connectionTimeout = Integer.parseInt(SessionProperties.SINGLETON.SESSION_PROPERTIES.getProperty("jdbc.url.connect.timeout", "3"));
            Preconditions.checkArgument((socketTimeout >= 0 && socketTimeout <= 30 ? 1 : 0) != 0, (Object)"The variable \"jdbc.url.socket.timeout\" is out of range. Valid range: [0,30]");
            Preconditions.checkArgument((connectionTimeout >= 0 && connectionTimeout <= 30 ? 1 : 0) != 0, (Object)"The variable \"jdbc.url.connect.timeout\" is out of range. Valid range: [0,30]");
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Parse session.properties failed. Error: " + e);
        }
    }

    static {
        Properties props = PropertiesUtils.loadProperties((String)SESSION_PROPERTY_PATH);
        for (SessionVariable variable : SessionVariable.values()) {
            String value = props.getProperty(variable.variableName);
            SessionProperties.SINGLETON.SESSION_PROPERTIES.put(variable.variableName, variable.getValue(value));
        }
        if (props.size() > 0) {
            SessionProperties.validateProperties();
        }
    }

    static enum SessionVariable {
        QUERY_FOR_INIT_SESSION("ob.timeout.for.query.metadata", "5", true),
        TRX_FOR_INIT_SESSION("ob.timeout.for.exec.ddl", "1", true),
        QUERY_FOR_DUMP_RECORD("ob.query.timeout.for.dump.record", "24", true),
        QUERY_FOR_EXEC_DML("ob.timeout.for.exec.dml", "1", true),
        TRX_FOR_DUMP_RECORD("ob.trx.timeout.for.dump.record", "24", true),
        NET_READ_FOR_DUMP_RECORD("ob.net.read.timeout.for.dump.record", "24", true),
        NET_READ_FOR_DUMP_CUSTOM("ob.net.read.timeout.for.dump.custom", "5", true),
        NET_WRITE_FOR_DUMP_RECORD("ob.net.write.timeout.for.dump.record", "24", true),
        PROXY_ROUTE_POLICY("ob.proxy.route.policy", "follower_first", false),
        JDBC_LOG("jdbc.url.log", "false", false),
        JDBC_USE_SSL("jdbc.url.use.ssl", "false", false),
        JDBC_USE_UNICODE("jdbc.url.use.unicode", "false", false),
        JDBC_SOCKET_TIMEOUT("jdbc.url.socket.timeout", "30", true),
        JDBC_CONNECT_TIMEOUT("jdbc.url.connect.timeout", "3", true),
        JDBC_CHARACTER_ENCODING("jdbc.url.character.encoding", "utf8", false),
        JDBC_USE_COMPRESSION("jdbc.url.use.compression", "true", false),
        JDBC_CACHE_PREP_STMTS("jdbc.url.cache.prep.stmts", "true", false),
        JDBC_NO_DATETIME_STRING_SYNC("jdbc.url.no.datetime.string.sync", "true", false),
        JDBC_USE_SERVER_PREP_STMTS("jdbc.url.use.server.prep.stmts", "true", false),
        JDBC_ALLOW_MULTI_QUERIES("jdbc.url.allow.multi.queries", "true", false),
        JDBC_REWRITE_BATCHED_STATEMENTS("jdbc.url.rewrite.batched.statements", "true", false),
        JDBC_USE_LOCAL_SESSION_STATE("jdbc.url.use.local.session.state", "true", false),
        JDBC_ZERO_DATETIME_BEHAVIOR("jdbc.url.zero.datetime.behavior", "convertToNull", false),
        JDBC_VERIFY_SERVER_CERTIFICATION("jdbc.url.verify.server.certificate", "false", false),
        JDBC_USE_PIPELINE_AUTH("jdbc.url.use.pipeline.auth", "false", false),
        JDBC_SOCKS_PROXY_HOST("jdbc.url.socks.proxy.host", null, false),
        JDBC_SOCKS_PROXY_PORT("jdbc.url.socks.proxy.port", null, false);

        private String defaultVal;
        private String variableName;
        private boolean numeric;

        private SessionVariable(String variableName, String defaultVal, boolean numeric) {
            this.defaultVal = defaultVal;
            this.variableName = variableName;
            this.numeric = numeric;
        }

        public String getValue(String value) {
            if (value == null) {
                return this.defaultVal == null ? "" : this.defaultVal;
            }
            if (this.numeric) {
                int intVal = NumberUtils.toInt((String)value, (int)Integer.parseInt(this.defaultVal));
                return Integer.toString(intVal);
            }
            return value;
        }
    }
}

